<?php
/**
* @version     	siteverification.php 16/01/2024
* @author 		Edwin Witlox $
* @copyright   	Copyright (C) Scorpion Computers and Software, Inc. All rights reserved.
* @license     	GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
* @email 		info@scorpioncomputers.nl
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;

/**
 * System - Scorpion Site Verification Plugin
 *
 * @since  1.0.0
 */
class PlgSystemSiteverification extends CMSPlugin
{

	/**
	 * Add site verification meta tags to the document head
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	public function onBeforeCompileHead()
	{
		// Get document
		$document = Factory::getDocument();

		// Get each of the verification keys
		$googlekey  = $this->params->get('googlekey');
		$bingkey    = $this->params->get('bingkey');
		$yahookey   = $this->params->get('yahookey');
		$alexakey   = $this->params->get('alexakey');
		$yandexkey  = $this->params->get('yandexkey');

		// Set meta tags
		if (!empty($googlekey))
		{
			$document->setMetaData('google-site-verification', $googlekey);
		}

		if (!empty($bingkey))
		{
			$document->setMetaData('msvalidate.01', $bingkey);
		}

		if (!empty($yahookey))
		{
			$document->setMetaData('y_key', $yahookey);
		}

		if (!empty($alexakey))
		{
			$document->setMetaData('alexaVerifyID', $alexakey);
		}

		if (!empty($yandexkey))
		{
			$document->setMetaData('yandex-verification', $yandexkey);
		}
	}
}
