<?php
/**
 * @version     changelog.php - 15/01/2024
 * @author 		Edwin Witlox $
 * @copyright  	Copyright (C) 2024 Scorpion Computers and Software, Inc. All rights reserved.
 * @license    	GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
 * @email 		info@scorpioncomputers.nl
 */

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormField;

class JFormFieldChangelog extends FormField
{
	protected $type = 'note';

	protected function getInput()
	{
		// get relevant attributes which were defined in the XML form definition
		$attr = !empty($this->class) ? ' class="' . $this->class . '"' : '';

		// Reading the content of the changelog into a string
		$filename = JPATH_ROOT.'/plugins/system/siteverification/changelog.txt';
		$output = file_get_contents($filename);

		// set up html, including the value and other attributes
		$html = '<pre style="overflow: visible;" name="' . $this->name . ' ' . $attr . '>' . $output . '</pre>';

		return $html;
	}

	public function getLabel()
	{
		return '<span style="text-decoration: underline;">' . parent::getLabel() . '</span>';
	}
}
