# Scorpion Weather Module voor Joomla 6

Een Joomla 6 module die weersvoorspellingen weergeeft met behulp van de gratis Open-Meteo API. De module toont gedetailleerde weersinformatie voor een specifieke locatie op basis van latitude en longitude coördinaten.

## Functies

- ✅ **Gratis weersvoorspelling** via Open-Meteo API (geen API-key vereist)
- ✅ **Tot 16 dagen** weersvoorspelling
- ✅ **Weersicoontjes** (SVG) per dag op basis van WMO codes
- ✅ **Kolomlayout**: één kolom per dag in responsive grid
- ✅ **Configurable weergave** van:
  - Luchtdruk (hPa) - alleen voor vandaag
  - Luchtvochtigheid (%) - alleen voor vandaag
  - Zicht (km/m) - alleen voor vandaag
  - Windkracht en windstoten (dagelijkse maximum)
  - Neerslag (mm) en neerslagkans (%)
  - Zonsopkomst en zonsondergang tijden
- ✅ **Aanpasbare eenheden**: Celsius/Fahrenheit, km/h/m/s/mph/knots
- ✅ **Caching** voor betere prestaties (configureerbaar 15-1440 minuten)
- ✅ **Meertalig**: Engels en Nederlands
- ✅ **Vertaalbare weerslabels** (WMO codes) in module taal
- ✅ **Gelokaliseerde datumformattering** (dagnamen en maandnamen)
- ✅ **Aanvullende CSS** tabblad voor custom styling
- ✅ **Optionele credit link** naar Open-Meteo.com
- ✅ **Responsive design** met moderne CSS en CSS variabelen

## Vereisten

- Joomla 6.x
- PHP 8.1 of hoger
- cURL extensie (meestal standaard aanwezig)
- Internetverbinding voor API calls

## Installatie

### Methode 1: Via Joomla Administrator

1. Download of maak een ZIP-bestand van de module
2. Ga naar **System → Install → Extensions**
3. Klik op **Upload Package File**
4. Selecteer het ZIP-bestand en klik op **Upload & Install**
5. De module is nu geïnstalleerd

### Methode 2: Handmatig installeren

1. Pak het ZIP-bestand uit
2. Upload de map `mod_scorpion_weather` naar `/modules/mod_scorpion_weather` op je server
3. Upload de taalbestanden naar `/language/en-GB` en `/language/nl-NL`
4. Upload de media bestanden naar `/media/mod_scorpion_weather`

## Configuratie

### Module aanmaken

1. Ga naar **Content → Site Modules** (of **System → Site Modules**)
2. Klik op **New**
3. Selecteer **Scorpion Weather** als module type
4. Configureer de instellingen:

### Basis Instellingen

#### Locatie
- **Latitude**: Breedtegraad van de locatie (bijv. `52.3676` voor Amsterdam)
- **Longitude**: Lengtegraad van de locatie (bijv. `4.9041` voor Amsterdam)

> 💡 **Tip**: Je kunt coördinaten vinden via [Google Maps](https://www.google.com/maps) door rechts te klikken op een locatie.

#### Voorspelling
- **Aantal dagen**: Aantal dagen om weer te geven (1-16, standaard: 7)
- **Cache (minuten)**: Hoe lang data gecached wordt (15-1440 minuten, standaard: 60)

### Weergave Opties

Schakel de volgende opties in/uit:
- ✅ **Toon wind**: Windsnelheid en windstoten (dagelijkse maximum)
- ✅ **Toon neerslag**: Neerslaghoeveelheid (mm) en neerslagkans (%)
- ✅ **Toon zonsopkomst & zonsondergang**: Tijden wanneer de zon opkomt en ondergaat
- ✅ **Toon luchtdruk**: Huidige luchtdruk (alleen voor vandaag, uit hourly data)
- ✅ **Toon luchtvochtigheid**: Huidige luchtvochtigheid (alleen voor vandaag, uit hourly data)
- ✅ **Toon zicht**: Huidige zichtbaarheid (alleen voor vandaag, uit hourly data)

> **Let op:** Luchtdruk, luchtvochtigheid en zicht worden alleen getoond voor **vandaag** (eerste dag), omdat deze alleen beschikbaar zijn als hourly variabelen in de Open-Meteo API. Voor toekomstige dagen worden deze waarden niet getoond.

### Eenheden

- **Temperatuureenheid**: Celsius of Fahrenheit
- **Windsnelheid-eenheid**: km/h, m/s, mph of knopen

### Aanvullende CSS

- **Aangepaste CSS**: Voeg extra CSS toe om de module te stylen via het "Aanvullende CSS" tabblad
- Gebruik de wrapper class `.mod-scorpion-weather` (of je module class suffix) om alleen deze module te beïnvloeden

**Voorbeeld CSS:**
```css
.mod-scorpion-weather {
    --mod-weather-accent: #dc2626;
    --mod-weather-icon: #f59e0b;
}

.mod-scorpion-weather__day {
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0,0,0,.1);
}
```

### Module Positie

1. Selecteer een **Module Position** (bijv. `position-7`, `sidebar-right`, etc.)
2. Of gebruik **Menu Assignment** om de module alleen op specifieke pagina's te tonen

## Gebruik

### Coördinaten vinden

**Via Google Maps:**
1. Ga naar [Google Maps](https://www.google.com/maps)
2. Zoek je locatie
3. Rechts klik op de locatie
4. Selecteer de coördinaten (bijv. `52.3676, 4.9041`)
5. Kopieer de eerste waarde (latitude) en tweede waarde (longitude)

**Via andere tools:**
- [LatLong.net](https://www.latlong.net/)
- [OpenStreetMap](https://www.openstreetmap.org/)

### Voorbeeld Coördinaten

| Stad | Latitude | Longitude |
|------|----------|-----------|
| Amsterdam | 52.3676 | 4.9041 |
| Rotterdam | 51.9244 | 4.4777 |
| Den Haag | 52.0705 | 4.3007 |
| Utrecht | 52.0907 | 5.1214 |
| Brussel | 50.8503 | 4.3517 |
| Parijs | 48.8566 | 2.3522 |
| Londen | 51.5074 | -0.1278 |
| Berlijn | 52.5200 | 13.4050 |

## Weergave

De module toont elke dag in een **eigen kolom** met:
- **Datum** (gelokaliseerd, bijv. "Maa 9 feb" of "Mon 9 Feb")
- **Weericoon** (SVG icoon op basis van WMO code: zon, wolk, regen, sneeuw, onweer, etc.)
- **Weersomschrijving** (vertaald, bijv. "Gedeeltelijk bewolkt" of "Partly cloudy")
- **Maximum temperatuur** / **Minimum temperatuur**
- **Neerslag** (indien ingeschakeld) met hoeveelheid en kans
- **Wind** (indien ingeschakeld) met snelheid en eventuele stoten
- **Luchtdruk** (indien ingeschakeld, alleen voor vandaag)
- **Luchtvochtigheid** (indien ingeschakeld, alleen voor vandaag)
- **Zicht** (indien ingeschakeld, alleen voor vandaag)
- **Zonsopkomst & zonsondergang** (indien ingeschakeld)

**Layout:**
- Responsive grid: automatisch aantal kolommen op basis van beschikbare ruimte
- Elke dag krijgt een eigen kaart met weericoon en informatie
- Op mobiel: minder kolommen (2 of 1) voor betere leesbaarheid

## API Informatie

De module gebruikt de gratis [Open-Meteo API](https://open-meteo.com/):
- ✅ Geen API-key vereist
- ✅ Geen registratie nodig
- ✅ Gratis voor niet-commercieel gebruik
- ✅ Tot 16 dagen voorspelling
- ✅ Wereldwijde dekking

Voor commerciële doeleinden, zie [Open-Meteo Pricing](https://open-meteo.com/en/pricing).

## Troubleshooting

### Geen data wordt getoond

1. **Controleer coördinaten**: Zorg dat latitude en longitude correct zijn ingevuld
2. **Controleer cache**: Leeg de Joomla cache via **System → Clear Cache**
3. **Controleer internetverbinding**: De module heeft internet nodig voor API calls
4. **Controleer PHP cURL**: Zorg dat de cURL extensie actief is
5. **Controleer logs**: Bekijk Joomla error logs voor foutmeldingen

### Data is verouderd

- Verlaag de cache tijd in module instellingen
- Of leeg de cache handmatig via **System → Clear Cache**

### Module verschijnt niet

1. Controleer of de module **Published** is
2. Controleer de **Module Position** instelling
3. Controleer **Menu Assignment** (als ingesteld)
4. Controleer of de template de module positie ondersteunt

## Styling Aanpassen

De module gebruikt CSS variabelen voor eenvoudige aanpassing. Je kunt de styling overschrijven via je template CSS:

```css
.mod-scorpion-weather {
    --mod-weather-bg: #f8fafc;
    --mod-weather-border: #e2e8f0;
    --mod-weather-text: #1e293b;
    --mod-weather-muted: #64748b;
    --mod-weather-accent: #0ea5e9;
}
```

## Technische Details

### Bestandsstructuur

```
mod_scorpion_weather/
├── mod_scorpion_weather.xml           # Manifest bestand
├── mod_scorpion_weather_changelog.xml # Changelog (Joomla-formaat)
├── mod_scorpion_weather.php           # Hoofdmodule bestand
├── helper.php                         # API helper met caching
├── tmpl/
│   └── default.php                    # Standaard template
├── media/
│   └── css/
│       └── default.min.css            # Styling
└── language/
    ├── en-GB/
    │   ├── en-GB.mod_scorpion_weather.ini
    │   └── en-GB.mod_scorpion_weather.sys.ini
    └── nl-NL/
        ├── nl-NL.mod_scorpion_weather.ini
        └── nl-NL.mod_scorpion_weather.sys.ini
```

### Cache

De module gebruikt Joomla's output cache systeem:
- Standaard cache tijd: 60 minuten
- Configureerbaar: 15-1440 minuten
- Cache wordt automatisch gewist bij module configuratie wijzigingen

### API Endpoint

De module gebruikt:
```
https://api.open-meteo.com/v1/forecast
```

### Changelog in Joomla back-end

Het manifest verwijst naar een changelog-URL (`changelogurl`). Om de changelog zichtbaar te maken in **System → Manage Extensions** (bij klik op het versienummer) of bij updates:

1. Host het bestand `mod_scorpion_weather_changelog.xml` op een bereikbare URL (bijv. je website of update-server).
2. Pas in `mod_scorpion_weather.xml` de tag `<changelogurl>` aan naar die URL (zonder spaties of regeleinden rond de URL).

Zie [Joomla Changelogs documentatie](https://manual.joomla.org/docs/5.4/building-extensions/install-update/installation/change-log/).

## Licentie

GNU General Public License version 2 or later

## Credits

- **Weerdata**: [Open-Meteo.com](https://open-meteo.com/) - Gratis weersvoorspelling API
- **Module**: Scorpion Weather voor Joomla 6
- **Gemaakt door**: [Scorpion Computers & Software](http://ScorpionComputers.nl)

## Ondersteuning

Voor vragen, bug reports of suggesties:
- Controleer eerst de troubleshooting sectie
- Bekijk de [Open-Meteo documentatie](https://open-meteo.com/en/docs)
- Controleer Joomla error logs

## Changelog

### Versie 1.0.0
- Eerste release
- Weersvoorspelling via Open-Meteo API (gratis, geen API-key)
- Configurable locatie (latitude, longitude)
- Voorspelling lengte: 1–16 dagen
- Weersicoontjes (SVG) per dag op basis van WMO codes
- Kolomlayout: één kolom per dag, responsive grid
- Optionele weergave: luchtdruk, luchtvochtigheid, zicht (huidige waarden alleen voor vandaag), wind, neerslag
- Optionele zonsopkomst en zonsondergang tijden per dag
- Temperatuureenheid: Celsius of Fahrenheit
- Windsnelheid-eenheid: km/h, m/s, mph, knopen
- Output caching (configureerbaar 15–1440 minuten)
- Talen: Engels (en-GB) en Nederlands (nl-NL)
- Vertaalbare weerslabels (WMO codes) in module taal
- Gelokaliseerde datumformattering (dagnamen en maandnamen)
- Aanvullende CSS tabblad voor extra styling
- Optionele credit link naar Open-Meteo.com
- Responsive layout met CSS variabelen voor theming

## Toekomstige Verbeteringen

Mogelijke toekomstige features:
- [ ] Meerdere locaties in één module
- [ ] Weerkaarten/grafieken
- [ ] Hourly forecast weergave (volledige 24-uurs voorspelling)
- [ ] Automatische locatie detectie (via browser geolocation)
- [ ] Aanpasbare templates/layouts
- [ ] Weer animaties/transitions

---

**Versie**: 1.0.0  
**Compatibiliteit**: Joomla 6.x  
**PHP Vereiste**: 8.1+


## Testing

Url for testing open-meteo.com
https://api.open-meteo.com/v1/forecast?latitude=52.3676&longitude=4.9041&forecast_days=1&daily=temperature_2m_max,temperature_2m_min,weather_code&timezone=auto 