<?php

/**
 * This module displays social sharing buttons for Joomla 3+
 *
 * @version     25-03-2024
 * @package     Joomla.mod_scorpion_socialshare
 * @subpackage  Modules
 * @link        https://ScorpionComputers.nl
 * @license     GNU/GPL, see LICENSE.php
 * 
 * mod_scorpion_socialshare is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
if ($buttonPosition != 'here') {
  $offsetStyle = "top:" . $buttonPositionOffset . ";";
} else {
  $offsetStyle = "";
}
if ($buttonStyle != 'custom') {
  $offsetStyleContent = "";
} else {
  $offsetStyleContent = "background-color:" . $buttonStyleBackgroundColor . ";color:" . $buttonStyleColor . ";";
}

if ($showLabels) {
  $label2displayClass = "withLabels";
} else {
  $label2displayClass = "noLabels";
}

if ($showFacebook) {
  if ($showLabels) {
    $label2display = "Facebook";
  } else {
    $label2display = "";
  }
  $outputIcon = "<i class='fa-brands fa-facebook-f'></i>";
  $outputClass = "scs-link-facebook";
  $outputUrl = $facebookURL;

  $outputIconLeft = $buttonPosition == 'top-right' ? "" : $outputIcon;
  $outputIconRight = $buttonPosition == 'top-right' ? $outputIcon : "";

  $outputFacebook = "<a href='" . $outputUrl . "' class='" . $outputClass . "' target='_blank' style='" . $offsetStyleContent . "'>" . $outputIconLeft . "<span>" . $label2display . $outputIconRight . "</span></a>";
}
if ($showTwitter) {
  if ($showLabels) {
    $label2display = "X (Twitter)";
  } else {
    $label2display = "";
  }
  $outputIcon = "<i class='fa-brands fa-x-twitter'></i>";
  $outputClass = "scs-link-twitter";
  $outputUrl = $twitterURL;

  $outputIconLeft = $buttonPosition == 'top-right' ? "" : $outputIcon;
  $outputIconRight = $buttonPosition == 'top-right' ? $outputIcon : "";

  $outputTwitter = "<a href='" . $outputUrl . "' class='" . $outputClass . "' target='_blank' style='" . $offsetStyleContent . "'>" . $outputIconLeft . "<span>" . $label2display . $outputIconRight . "</span></a>";
}
if ($showLinkedIn) {
  if ($showLabels) {
    $label2display = "LinkedIn";
  } else {
    $label2display = "";
  }
  $outputIcon = "<i class='fa-brands fa-linkedin'></i>";
  $outputClass = "scs-link-linkedin";
  $outputUrl = $linkedInURL;

  $outputIconLeft = $buttonPosition == 'top-right' ? "" : $outputIcon;
  $outputIconRight = $buttonPosition == 'top-right' ? $outputIcon : "";

  $outputLinkedIn = "<a href='" . $outputUrl . "' class='" . $outputClass . "' target='_blank' style='" . $offsetStyleContent . "'>" . $outputIconLeft . "<span>" . $label2display . $outputIconRight . "</span></a>";
}
if ($showPinterest) {
  if ($showLabels) {
    $label2display = "Pinterest";
  } else {
    $label2display = "";
  }
  $outputIcon = "<i class='fa-brands fa-pinterest-p'></i>";
  $outputClass = "scs-link-pinterest";
  $outputUrl = $pinterestURL;

  $outputIconLeft = $buttonPosition == 'top-right' ? "" : $outputIcon;
  $outputIconRight = $buttonPosition == 'top-right' ? $outputIcon : "";

  $outputPinterest = "<a href='" . $outputUrl . "' class='" . $outputClass . "' target='_blank' style='" . $offsetStyleContent . "'>" . $outputIconLeft . "<span>" . $label2display . $outputIconRight . "</span></a>";
}
if ($showEmail) {
  if ($showLabels) {
    $label2display = "E-Mail";
  } else {
    $label2display = "";
  }
  $outputIcon = "<i class='fa-solid fa-envelope'></i>";
  $outputClass = "scs-link-email";
  $outputUrl = $emailURL;

  $outputIconLeft = $buttonPosition == 'top-right' ? "" : $outputIcon;
  $outputIconRight = $buttonPosition == 'top-right' ? $outputIcon : "";

  $outputEmail = "<a href='" . $outputUrl . "' class='" . $outputClass . "' target='_blank' style='" . $offsetStyleContent . "'>" . $outputIconLeft . "<span>" . $label2display . $outputIconRight . "</span></a>";
}

?>
<div id="scs-mod-socialshare" class="scs-mod-socialshare<?php echo $moduleclass_sfx; ?>
<?php
echo ' ' . $label2displayClass;
echo ' ' . $buttonStyle;
echo ' ' . $buttonPosition;
echo ' ' . $hideOnMobile;
?>
" 
<?php echo "style='" . $offsetStyle . "'"; ?>>
  <div class="scs-position ">
    <?php echo $outputFacebook ?>
    <?php echo $outputTwitter ?>
    <?php echo $outputLinkedIn ?>
    <?php echo $outputPinterest ?>
    <?php echo $outputEmail ?>
  </div>
</div>
<div style="clear:both;"></div>