<?php
/**
 * This module displays social sharing buttons for Joomla 3+
 *
 * @version     25-03-2024
 * @package     Joomla.mod_scorpion_socialshare
 * @subpackage  Modules
 * @link        http://ScorpionComputers.nl
 * @license     GNU/GPL, see LICENSE.php
 * mod_scorpion_socialshare is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;

// Include the syndicate functions only once
require_once __DIR__ . '/lib/helper.php';

$doc = Factory::getDocument();
$title = $doc->getTitle();
$doc->addStyleSheet('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css');
$doc->addStyleSheet('modules/mod_scorpion_socialshare/mod_scorpion_socialshare.css');
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
$showFacebook = $params->get( 'showFacebook' );
$showTwitter = $params->get( 'showTwitter' );
$showLinkedIn = $params->get( 'showLinkedIn' );
$showPinterest = $params->get( 'showPinterest' );
$showEmail = $params->get( 'showEmail' );
$shareBaseURL = $params->get( 'shareBaseURL' );
$shareOtherURL = $params->get( 'shareOtherURL' );
$buttonPosition = $params->get( 'buttonPosition' );
$buttonPositionOffset = $params->get( 'buttonPositionOffset', '100px' );
$buttonStyle = $params->get( 'buttonStyle' );
$showLabels = $params->get( 'showLabels' );
$hideOnMobile = $params->get( 'hideOnMobile' );
$addMetatagsOG = $params->get( 'addMetatagsOG' );
$addMetatagsTW = $params->get( 'addMetatagsTW' );
$metaWebsiteName = $params->get( 'metaWebsiteName' );
$metaWebsiteImage = $params->get( 'metaWebsiteImage' );
$buttonStyleColor = $params->get( 'buttonStyleColor' );
$buttonStyleBackgroundColor = $params->get( 'buttonStyleBackgroundColor' );

$facebookURL = modScorpionSocialShare::getSocialShareURL( 'facebook', $params );
$twitterURL = modScorpionSocialShare::getSocialShareURL( 'twitter', $params );
$linkedInURL = modScorpionSocialShare::getSocialShareURL( 'linkedin', $params );
$pinterestURL = modScorpionSocialShare::getSocialShareURL( 'pinterest', $params );
$emailURL = modScorpionSocialShare::getSocialShareURL( 'email', $params );

modScorpionSocialShare::setOpenGraphMetaTags($params);

require( ModuleHelper::getLayoutPath( 'mod_scorpion_socialshare' ) );

?>
