<?php

/**
 * @version      25-03-204
 * @copyright    Copyright (C) Scorpion Computers and Software, Inc. All rights reserved.
 * @license      GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
 * @email        info@ScorpionComputers.nl
 */

// No direct access to this file
defined('_JEXEC') or die;

class moduleSettings
{
    public $moduleNameTech = 'mod_scorpion_socialshare';
    public $moduleNameFull = 'Scorpion Social Share';
}

class mod_scorpion_socialshareInstallerScript
{
    // This is run with the first installation of the module
    public function install($parent)
    {
        showScorpionInfo();
        showSuccesMessage('install');
        getLatestChangelog(false);
    }

    // This is run with the update of the module
    function update($parent)
    {
        showScorpionInfo();
        getLatestChangelog(true);
        showSuccesMessage('update');
    }
}

function showScorpionInfo()
{
    $settings = new moduleSettings;
    $infoText = '<h2>' . $settings->moduleNameFull . '</h2>';
    echo $infoText;
}

function showSuccesMessage($installType)
{
    $settings = new moduleSettings;

    $msgStyleBefore = '<p style="border-radius:4px;display:block;border:1px solid #BCE8F1;padding:10px 15px;background:#D8EDF7;color:#31718F;font-weight:400;">';
    $msgStyleAfter = '</p>';
    $linkToModuleManager = '<strong><a style="color:#333;text-decoration:underline;" href="index.php?option=com_modules&view=modules&filter_search=&filter_module=' . $settings->moduleNameTech . '">Open Module Manager</a></strong> to publish the module.';
    $msgInstall = $msgStyleBefore . '' . $settings->moduleNameFull . ' is installed succesfully. ' . $linkToModuleManager . $msgStyleAfter;
    $msgUpdate = $msgStyleBefore . '' . $settings->moduleNameFull . ' is updated succesfully. ' . $linkToModuleManager . $msgStyleAfter;
    if ($installType == 'install') {
        echo $msgInstall;
    } else if ($installType == 'update') {
        echo $msgUpdate;
    }
}

function getLatestChangelog($onlyLatest)
{
    $settings = new moduleSettings;
    // Reading the content of the changelog into a string
    $filenameWithPath = JPATH_ROOT . '/modules/' . $settings->moduleNameTech . '/changelog.txt';
    $allChanges = file_get_contents($filenameWithPath);
    $onlyLastestChanges = explode('-----', $allChanges);

    $output = $onlyLatest ? '<h4>New in this version</h4>' : '<h4>Changelog</h4>';
    $output .= '<pre>';
    $output .= $onlyLatest ? $onlyLastestChanges[0] : $allChanges;
    $output .= '</pre>';
    echo $output;
}
