<?php
/**
 * This module displays social sharing buttons for Joomla 3+
 *
 * @version     25-03-2024
 * @package     Joomla.mod_scorpion_socialshare
 * @subpackage  Modules
 * @link        http://ScorpionComputers.nl
 * @license     GNU/GPL, see LICENSE.php
 * mod_scorpion_socialshare is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;

class modScorpionSocialShare
{
  /**
   * Set Open Graph metatags for SocialMedia
   * @param array $params An object containing the module parameters
   * @access public
   */
  public static function setOpenGraphMetaTags( $params )
  {
    $doc = Factory::getDocument();
    $url = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    $websiteDescription = htmlspecialchars($doc->getMetaData( 'description' ));
    $websiteTitle = htmlspecialchars($doc->getTitle());
    $shareBaseURL = $params->get( 'shareBaseURL' );
    $shareOtherURL = $params->get( 'shareOtherURL' );
    $metaWebsiteName = $params->get( 'metaWebsiteName' );
    $metaWebsiteImage = $params->get( 'metaWebsiteImage' );
    $addMetatagsOG = $params->get( 'addMetatagsOG' );
    $addMetatagsTW = $params->get( 'addMetatagsTW' );

    if($addMetatagsOG){
      $doc->addCustomTag( '<meta property="og:title" content="'.$metaWebsiteName.'"/>');
      $doc->addCustomTag( '<meta property="og:site_name" content="'.$metaWebsiteName.'"/>');
      $doc->addCustomTag( '<meta property="og:description" content="'.$websiteDescription.'"/>');
      $doc->addCustomTag( '<meta property="og:image" content="'.$url.$metaWebsiteImage.'"/>');
      $doc->addCustomTag( '<meta property="og:type" content="website"/>');

      if($shareBaseURL){
        $doc->addCustomTag( '<meta property="og:url" content="'.$url.'"/>');
      } else {
        $doc->addCustomTag( '<meta property="og:url" content="'.$shareOtherURL.'"/>');
      }
    }

    if($addMetatagsTW){
      $doc->addCustomTag( '<meta property="twitter:title" content="'.$metaWebsiteName.'"/>');
      $doc->addCustomTag( '<meta property="twitter:description" content="'.$websiteDescription.'"/>');
      $doc->addCustomTag( '<meta property="twitter:image" content="'.$url.$metaWebsiteImage.'"/>');

      if($shareBaseURL){
        $doc->addCustomTag( '<meta property="twitter:url" content="'.$url.'"/>');
      } else {
        $doc->addCustomTag( '<meta property="twitter:url" content="'.$shareOtherURL.'"/>');
      }
    }

  }

    /**
     * Retrieves the share URL for SocialMedia
     * @param array $params An object containing the module parameters
     * @access public
     */
    public static function getSocialShareURL( $SocialSite, $params )
    {
      $doc = Factory::getDocument();
      $url = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

      $websiteTitle = $doc->getTitle();
      $websiteDescription = $doc->getMetaData( 'description' );
      $metaWebsiteImage = $params->get( 'metaWebsiteImage' );
      $shareBaseURL = $params->get( 'shareBaseURL' );
      $shareOtherURL = $params->get( 'shareOtherURL' );

      switch($SocialSite){
        case "facebook":
          // $socialUrl = "https://www.facebook.com/sharer/sharer.php?p[images][0]=".$url.$metaWebsiteImage."&u=";
          $socialUrl = "https://www.facebook.com/sharer/sharer.php?u=";
          break;
        case "twitter":
          $socialUrl = "https://twitter.com/share?text=".$websiteDescription."&amp;url=";
          break;
        case "linkedin":
          $socialUrl = "https://www.linkedin.com/shareArticle?mini=true&amp;url=";
          break;
        case "pinterest":
          $socialUrl = "https://pinterest.com/pin/create/bookmarklet/?media=&amp;description=".$websiteDescription."&amp;url=";
          break;
        case "email":
          $socialUrl = "mailto:?subject=".$websiteTitle."&amp;body=".$websiteDescription."%3A%0A";
          break;
        default:
          $socialUrl = "";
          break;
      }
      if($shareBaseURL) {
        $socialUrl .= $url;
      } else {
        $socialUrl .= $shareOtherURL;
      }
      return $socialUrl;
    }
}
?>
