<?php
/**
* @version		changelog.php - 24/04/2024
* @author		Edwin Witlox $
* @copyright	Copyright (C) Scorpion Computers and Software, Inc. All rights reserved.
* @license		GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
* @email		info@ScorpionComputers.nl
*/
// no direct access
defined('_JEXEC') or die('Restricted access');

use \Joomla\CMS\Form\FormField;

class moduleSettings {
	public $moduleNameTech = 'mod_scorpion_socialshare';
    public $moduleNameFull = 'Scorpion Social Share';
}

class JFormFieldChangelog extends FormField
{
	protected $type = 'note';
	
	protected function getInput()
	{
		$settings = new moduleSettings;

		// get relevant attributes which were defined in the XML form definition
		$attr = !empty($this->class) ? ' class="' . $this->class . '"' : '';

		// Reading the content of the changelog into a string
		$filename = JPATH_ROOT.'/modules/'.$settings->moduleNameTech.'/changelog.txt';
		$output = file_get_contents($filename);
		
		// set up html, including the value and other attributes
		$html = '<pre style="overflow: visible;" name="' . $this->name . ' ' . $attr . '>'.$output.'</pre>';

		return $html;
	}

	public function getLabel() {
		return '<span style="text-decoration: underline;">' . parent::getLabel() . '</span>';
	}
}
