<?php
/**
* @version		mod_scorpion_countdown.php - 13/07/2025
* @author		Edwin Witlox
* @copyright	Copyright (C) Scorpion Computers and Software, Inc. All rights reserved.
* @license		GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
* @email		info@ScorpionComputers.nl
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

// use Joomla\CMS\Helper\ModuleHelper;
require_once __DIR__ . '/lib/mod_scorpion_countdown_helper.php';

// use multi language in the module
$language = Factory::getApplication()->getLanguage();
$language->load('mod_scorpion_countdown', JPATH_BASE . '/modules/mod_scorpion_countdown');
use Joomla\CMS\Language\Text;
$textDays = Text::_('SCS_COUNTDOWN_LABEL_DAYS');
$textHours = Text::_('SCS_COUNTDOWN_LABEL_HOURS');
$textMinutes = Text::_('SCS_COUNTDOWN_LABEL_MINUTES');
$textSeconds = Text::_('SCS_COUNTDOWN_LABEL_SECONDS');

// First we get the parameters from the module
$document = Factory::getDocument();
$baseURL = Uri::root(true);

$endDate = $params->get( 'endDate');
$showTitle = $params->get( 'showTitle', 1);
$title = $params->get( 'title', '');
$someOffset = $params->get( 'someOffset', 0);
$showSubTitle = $params->get( 'showSubTitle', 1);
$subtitle = $params->get( 'subtitle', '');
$widthOnDesktop = $params->get( 'widthOnDesktop', 75 );
$widthOnMobile = $params->get( 'widthOnMobile', 100 );
$colorCounters = $params->get( 'colorCounters', '#000000' );
$colorLabels = $params->get( 'colorLabels', '#000000' );
$colorBorders = $params->get( 'colorBorders', '#000000' );
$moreStyle = $params->get( 'moreStyle');
$loadJQuery = $params->get( 'loadJQuery', 0);
$showSeconds = $params->get( 'showSeconds', 1);

// We first add the script and the stylesheet that belong to this module
// We need the jQuery Easing plugin to make the number change in a smooth matter
if ($loadJQuery) {
	$document->addScript('https://code.jquery.com/jquery-3.7.1.min.js', array(), array('integrity'=>'sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=','crossorigin'=>'anonymous'));
}
$document->addScript('https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.4.1/jquery.easing.min.js');

// Add the CSS file from this module
$urlCSS = $baseURL.'/modules/mod_scorpion_countdown/mod_scorpion_countdown.css';
$document->addStyleSheet($urlCSS);

// We change the background color to the selected color
$extraStyle = ''."\r\n";
$extraStyle .= 'ul#scs-countdown {'."\r\n";
$extraStyle .= '	width:'.$widthOnDesktop.'% ; '."\r\n";
$extraStyle .= '	color:'.$colorCounters.' ; '."\r\n";
$extraStyle .= '	border: 1px solid '.$colorBorders.';'."\r\n";
$extraStyle .= '}'."\r\n";
$extraStyle .= 'ul#scs-countdown .label  { color:'.$colorLabels.' ; }'."\r\n";

// Set extra styling specifically for mobile
$extraStyle .= '@media only screen and (max-width: 768px) {'."\r\n";
$extraStyle .= '	ul#scs-countdown { width:'.$widthOnMobile.'% ; }'."\r\n";
$extraStyle .= '}'."\r\n"; 

// Adding style tag to the top of the HTML document for better support by browsers
// $document->addStyleDeclaration( $extraStyle ); // This would add the css in the part of the html where the module is placed
$stylelink = '<style>'."\r\n";
$stylelink .= '/* Styling for Scorpion Countdown module */'."\r\n";
$stylelink .= $extraStyle."\r\n";
$stylelink .= $moreStyle."\r\n";
$stylelink .= '</style>';
$document->addCustomTag($stylelink);
// $document->addStyleDeclaration( $stylelink );

// Now we set the HTML-code that needs to be implemented for this video module
$htmlCode = "\r\n".'<!-- Scorpion Countdown - BEGIN -->'."\r\n";
$htmlCode .= '<div class="scs-countdown-wrapper">'."\r\n";

if ($showTitle) {
	$htmlCode .= '<h2 style="text-align: center;">'.$title.'</h2>'."\r\n";
}

if ($showSubTitle) {
	$htmlCode .= '<p style="text-align: center;">'.$subtitle.'</p>'."\r\n";
}

$nrOfElementsClass = 'showfour';
if(!$showSeconds) {
	$nrOfElementsClass = 'showthree';
}

$htmlCode .= '<ul id="scs-countdown" class="'.$nrOfElementsClass.'">'."\r\n";

$htmlCode .= '	<li id="days">'."\r\n";
$htmlCode .= '		<div class="number">00</div>'."\r\n";
$htmlCode .= '		<div class="label">'.$textDays.'</div>'."\r\n";
$htmlCode .= '	</li>'."\r\n";

$htmlCode .= '	<li id="hours">'."\r\n";
$htmlCode .= '		<div class="number">00</div>'."\r\n";
$htmlCode .= '		<div class="label">'.$textHours.'</div>'."\r\n";
$htmlCode .= '	</li>'."\r\n";

$htmlCode .= '	<li id="minutes">'."\r\n";
$htmlCode .= '		<div class="number">00</div>'."\r\n";
$htmlCode .= '		<div class="label">'.$textMinutes.'</div>'."\r\n";
$htmlCode .= '	</li>'."\r\n";

if($showSeconds) {
	$htmlCode .= '	<li id="seconds">'."\r\n";
	$htmlCode .= '		<div class="number">00</div>'."\r\n";
	$htmlCode .= '		<div class="label">'.$textSeconds.'</div>'."\r\n";
	$htmlCode .= '	</li>'."\r\n";
}

$htmlCode .= '</ul>'."\r\n";
$htmlCode .= '</div>'."\r\n";
$htmlCode .='<!-- Scorpion Countdown - END -->'."\r\n";

echo $htmlCode;

// Extra JavaScript to set everything in motion
$document->addScriptDeclaration('

	// The date you want to count down to
	var targetDate = new Date("'.$endDate.'");

	// Other date related variables
	var days;
	var hrs;
	var min;
	var sec;
	var someOffset = '.$someOffset.';

	// window.event("domready", function() {
	jQuery(document).ready(function () {
		// Calculate time until launch date
		timeToLaunch();

		// Transition the current countdown from 0 
		numberTransition("#days .number", days, 1000, "easeOutQuad");
		numberTransition("#hours .number", hrs, 1000, "easeOutQuad");
		numberTransition("#minutes .number", min, 1000, "easeOutQuad");
		numberTransition("#seconds .number", sec, 1000, "easeOutQuad");

		// Begin Countdown
		setTimeout(countDownTimer(), 1001);
    });

	/* --------------------------
	* DISPLAY THE CURRENT COUNT TO LAUNCH
	* -------------------------- */
	function countDownTimer() {
		// Figure out the time to launch
		timeToLaunch();

		// Write to countdown component
		jQuery("#days .number").text(days);
		jQuery("#hours .number").text(hrs);
		jQuery("#minutes .number").text(min);
		jQuery("#seconds .number").text(sec);

		// Repeat the check every second
		setTimeout(countDownTimer, 1000);
	}
	
	/* --------------------------
	* FIGURE OUT THE AMOUNT OF TIME LEFT BEFORE LAUNCH
	* -------------------------- */
	function timeToLaunch() {
		// alert("timeToLaunch");
		// Get the current date
		var currentDate = new Date();
		currentDate.setTime(currentDate.getTime() + someOffset * 3600000);

		// Find the difference between dates
		var diff = (currentDate - targetDate) / 1000;
		var diff = Math.abs(Math.floor(diff));

		// Check number of days until target
		days = Math.floor(diff / (24 * 60 * 60));
		sec = diff - days * 24 * 60 * 60;

		// Check number of hours until target
		hrs = Math.floor(sec / (60 * 60));
		sec = sec - hrs * 60 * 60;

		// Check number of minutes until target
		min = Math.floor(sec / (60));
		sec = sec - min * 60;
	}

	/* --------------------------
	* TRANSITION NUMBERS FROM 0 TO CURRENT TIME UNTIL LAUNCH
	* -------------------------- */
	function numberTransition(id, endPoint, transitionDuration, transitionEase) {
		// Transition numbers from 0 to the final number
		jQuery({ numberCount: $(id).text() }).animate({ numberCount: endPoint }, {
		duration: transitionDuration,
		easing: transitionEase,
		step: function () {
			jQuery(id).text(Math.floor(this.numberCount));
		},
		complete: function () {
			jQuery(id).text(this.numberCount);
		}
		});
	};

');


// End of the code
?>
