<?php
/**
 * @version     scorpioncolumns.php - 05/01/2024
 * @author 		Edwin Witlox $
 * @copyright   Copyright (C) 2024 Scorpion Computers and Software, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
 * @email 		info@scorpioncomputers.nl
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
use \Joomla\CMS\Plugin\CMSPlugin;

require_once __DIR__ . '/lib/scorpionParameters.php';
require_once __DIR__ . '/lib/scorpionParser.php';
require_once __DIR__ . '/lib/scorpionHtmlBuilder.php';

class plgContentScorpionColumns extends CMSPlugin
{
    protected $autoloadLanguage = true;

    function __construct(&$subject, $params)
    {
        parent::__construct($subject, $params);
    }

    public function onContentPrepare($context, &$article, &$params, $limitstart)
    {
        $output = $article->text;
        $regex = "#{sc-col(.*?)}#s";
        $count = 0;

        // Looking for all column tags
        $found = preg_match_all($regex, $output, $matches);
        if ($found) {
            foreach ($matches[0] as $value) {

                // Plugin params are set to default values
                $plgParams = new scorpionParameters;

                $column = $value;
                $column = str_replace(array('<p>{sc-col}</p>', '<p>{sc-col ', '{sc-col ', '{sc-col}', '}</p>', '}'), '', $column);
                $find = '|';

                // Setting the parameters for the different sreensizes (if set in the plugin parameters)
                if (strstr($column, $find)) {
                    // New Parser object
                    $parser = new scorpionParser;
                    // Parse parameters
                    $parser->parse($column, $plgParams);
                } else {
                    // New Parser object
                    $parser = new scorpionParser;
                    // Parse parameters
                    $parser->parse($column, $plgParams);
                }

                // Create new HTML builder
                $builder = new scorpionHtmlBuilder;
                // Generate HTML code
                $replacement[$count] = $builder->html($plgParams);
                // Increase counter
                $count++;
            }
            for ($i = 0; $i < count($replacement); $i++) {
                $article->text = preg_replace($regex, $replacement[$i], $article->text, 1);
            }
        }

        // Replacing the original article text with the changed values
        $article->text = $this->removeExtraParagraphs($article->text);

        return true;
    }

    public function removeExtraParagraphs($inputText)
    {
        // The row-tags are simply replaced by the right html
        // Also the end-tags are replaced by the right html
        // And remove the empty paragraphs so that the html collums and rows have effect
        $inputText = str_replace(array('<p>{sc-row}</p>', '<p>{sc-row}', '{sc-row}</p>', '{sc-row}', '<p>{row}</p>', '<p>{row}', '{row}'), '<div class="row">', $inputText);
        $inputText = str_replace(array('<p>{/sc-row}</p>', '<p>{/sc-row}', '{/sc-row}</p>', '{/sc-row}', '<p>{/row}</p>', '{/row}'), '</div>', $inputText);
        $inputText = str_replace(array('<p>{/sc-col}</p>', '<p>{/sc-col}', '{/sc-col}</p>', '{/sc-col}', '<p>{/col}</p>', '<p>{/col}', '{/col}'), '</div>', $inputText);

        // Removing the leftover paragraph tags arround the collumns. Otherwise the columns are not functional
        // First without an id
        $regex2 = '#<p><div class="col(.*?)"></p>#s';
        $count2 = 0;
        $found2 = preg_match_all($regex2, $inputText, $matches2);
        if ($found2) {
            foreach ($matches2[0] as $value) {
                $replacement2[$count2] = str_replace(array('<p>', '</p>'), '', $value);
                for ($i2 = 0; $i2 < count($replacement2); $i2++) {
                    $inputText = preg_replace($regex2, $replacement2[$i2], $inputText, 1);
                }
            }
        }

        // The we also do it when there is an id set to the element
        $regex3 = '#<p><div id=".*?" class="col(.*?)"></p>#s';
        $count3 = 0;
        $found3 = preg_match_all($regex3, $inputText, $matches3);
        if ($found3) {
            foreach ($matches3[0] as $value) {
                $replacement3[$count3] = str_replace(array('<p>', '</p>'), '', $value);
                for ($i3 = 0; $i3 < count($replacement3); $i3++) {
                    $inputText = preg_replace($regex3, $replacement3[$i3], $inputText, 1);
                }
            }
        }

        // We also remove the paragraph that is left if the line only starts with a paragraph
        $inputText = str_replace('<p><div class="col', '<div class="col', $inputText);

        return $inputText;
    }
}
