<?php
/**
 * @version     plg_scorpion_install.php - 05/01/2024
 * @copyright   Copyright (C) Scorpion Computers and Software, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
 * @email 	    info@ScorpionComputers.nl
 */

// No direct access to this file
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

// The base settings for this plugin
class pluginSettings
{
    public $pluginNameTech = 'scorpioncolumns';
    public $pluginNameFull = 'Scorpion Columns';
}

// If it should be a system plugin change the classname
// class PlgSystemScorpioncolumnsInstallerScript
class PlgContentScorpioncolumnsInstallerScript
{

    // This is run with the first installation of the plugin
    public function install($parent)
    {
        enablePlugin();
        showScorpionInfo();
        showSuccesMessage('install');
        getLatestChangelog(false);
    }

    // This is run with the update of the plugin
    function update($parent)
    {

        showScorpionInfo();
        getLatestChangelog(true);
        showSuccesMessage('update');
    }
}

function enablePlugin()
{
    // Getting the main settings
    $settings = new pluginSettings;
    // Enable plugin
    $db  = Factory::getDbo();
    $query = $db->getQuery(true);
    $query->update('#__extensions');
    $query->set($db->quoteName('enabled') . ' = 1');
    $query->where($db->quoteName('element') . ' = ' . $db->quote($settings->pluginNameTech));
    $query->where($db->quoteName('type') . ' = ' . $db->quote('plugin'));
    $db->setQuery($query);
    $db->execute();
}

function showScorpionInfo()
{
    $settings = new pluginSettings;
    $infoText = '<h2>' . $settings->pluginNameFull . '</h2>';
    echo $infoText;
}

function showSuccesMessage($installType)
{
    $settings = new pluginSettings;
    $msgStyleBefore = '<p style="border-radius:4px;display:block;border:1px solid #BCE8F1;padding:10px 15px;background:#D8EDF7;color:#31718F;font-weight:400;">';
    $msgStyleAfter = '</p>';
    $linkToPluginManager = '<strong><a style="color:#333;text-decoration:underline;" href="index.php?option=com_plugins&view=plugins&filter_search=&filter_plugin=' . $settings->pluginNameTech . '">Open Plugin Manager</a></strong> to (un)publish the plugin.';
    $msgInstall = $msgStyleBefore . '' . $settings->pluginNameFull . ' is installed succesfully. ' . $linkToPluginManager . $msgStyleAfter;
    $msgUpdate = $msgStyleBefore . '' . $settings->pluginNameFull . ' is updated succesfully. ' . $linkToPluginManager . $msgStyleAfter;
    if ($installType == 'install') {
        echo $msgInstall;
    } else if ($installType == 'update') {
        echo $msgUpdate;
    }
}

function getLatestChangelog($onlyLatest)
{
    $settings = new pluginSettings;
    // Reading the content of the changelog into a string
    $filenameWithPath = JPATH_ROOT . '/plugins/content/' . $settings->pluginNameTech . '/changelog.txt';
    $allChanges = file_get_contents($filenameWithPath);
    $onlyLastestChanges = explode('-----', $allChanges);

    $output = $onlyLatest ? '<h4>New in this version</h4>' : '<h4>Changelog</h4>';
    $output .= '<pre>';
    $output .= $onlyLatest ? $onlyLastestChanges[0] : $allChanges;
    $output .= '</pre>';
    echo $output;
}
