<?php

/**
 * @version     	scorpionParser.php - 22/01/2024
 * @author 		    Edwin Witlox $
 * @copyright   	Copyright (C) 2024 Scorpion Computers and Software, Inc. All rights reserved.
 * @license     	GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
 * @email 		    info@scorpioncomputers.nl
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class scorpionParser
{
    // Parse values from the plugin variables into the paramaters needed for html building
    public function parse($string, &$params)
    {
        $arr = explode('|', $string);
        $params->setBase($arr[0]);
        foreach ($arr as $phrase) {
            if (strstr(strtolower($phrase), 'xs:')) {
                $tpm1 = explode(':', $phrase);
                $params->setXS(trim($tpm1[1], '"'));
            }
            if (strstr(strtolower($phrase), 'sm:')) {
                $tpm1 = explode(':', $phrase);
                $params->setSM(trim($tpm1[1], '"'));
            }
            if (strstr(strtolower($phrase), 'md:')) {
                $tpm1 = explode(':', $phrase);
                $params->setMD(trim($tpm1[1], '"'));
            }
            if (strstr(strtolower($phrase), 'lg:')) {
                $tpm1 = explode(':', $phrase);
                $params->setLG(trim($tpm1[1], '"'));
            }
            if (strstr(strtolower($phrase), 'xl:')) {
                $tpm1 = explode(':', $phrase);
                $params->setXL(trim($tpm1[1], '"'));
            }
            if (strstr(strtolower($phrase), 'xxl:')) {
                $tpm1 = explode(':', $phrase);
                $params->setXXL(trim($tpm1[1], '"'));
            }
            if (strstr(strtolower($phrase), 'class:')) {
                $tpm1 = explode(':', $phrase);
                $params->setExtraClass(trim($tpm1[1], '"'));
            }
            if (strstr(strtolower($phrase), 'id:')) {
                $tpm1 = explode(':', $phrase);
                $params->setElementID(trim($tpm1[1], '"'));
            }
        }
    }
}
