<?php

/**
 * @version     	scorpionParameters.php - 22/01/2024
 * @author 		    Edwin Witlox $
 * @copyright   	Copyright (C) 2024 Scorpion Computers and Software, Inc. All rights reserved.
 * @license     	GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
 * @email 		    info@scorpioncomputers.nl
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class scorpionParameters
{
    // setting the variables
    private $baseSize = 0;
    private $xsSize = 0;
    private $smSize = 0;
    private $mdSize = 0;
    private $lgSize = 0;
    private $xlSize = 0;
    private $xxlSize = 0;
    private $extraClass = '';
    private $elementID = '';

    // Getters and setters for each variable
    public function setBase($value)
    {
        $this->baseSize = $value;
    }

    public function getBase()
    {
        return $this->baseSize;
    }

    public function setXS($value)
    {
        $this->xsSize = $value;
    }

    public function getXS()
    {
        return $this->xsSize;
    }

    public function setSM($value)
    {
        $this->smSize = $value;
    }

    public function getSM()
    {
        return $this->smSize;
    }

    public function setMD($value)
    {
        $this->mdSize = $value;
    }

    public function getMD()
    {
        return $this->mdSize;
    }

    public function setLG($value)
    {
        $this->lgSize = $value;
    }

    public function getLG()
    {
        return $this->lgSize;
    }

    public function setXL($value)
    {
        $this->xlSize = $value;
    }

    public function getXL()
    {
        return $this->xlSize;
    }

    public function setXXL($value)
    {
        $this->xxlSize = $value;
    }

    public function getXXL()
    {
        return $this->xxlSize;
    }

    public function setExtraClass($value)
    {
        $this->extraClass = $value;
    }

    public function getExtraClass()
    {
        return $this->extraClass;
    }

    public function setElementID($value)
    {
        $this->elementID = $value;
    }

    public function getElementID()
    {
        return $this->elementID;
    }

    // produce a string with all parameters and their values
    public function toString()
    {
        $str = "base:" . $this->baseSize;
        $str .= ",xs:" . $this->xsSize;
        $str .= ",sm:" . $this->smSize;
        $str .= ",md:" . $this->mdSize;
        $str .= ",lg:" . $this->lgSize;
        $str .= ",xl:" . $this->xlSize;
        $str .= ",xxl:" . $this->xxlSize;
        $str .= ",class:" . $this->extraClass;
        $str .= ",id:" . $this->elementID;

        return $str;
    }

    // produce an object with all parameters and their values
    public function toObject()
    {
        $object = new stdClass();
        $object->base = $this->baseSize;
        $object->xs = $this->xsSize;
        $object->sm = $this->smSize;
        $object->md = $this->mdSize;
        $object->lg = $this->lgSize;
        $object->xl = $this->xlSize;
        $object->xxl = $this->xxlSize;
        $object->class = $this->extraClass;
        $object->id = $this->elementID;

        return $object;
    }
}
