<?php

/**
 * @version     scorpionHtmlBuilder.php - 22/01/2024
 * @author 		Edwin Witlox $
 * @copyright  	Copyright (C) 2024 Scorpion Computers and Software, Inc. All rights reserved.
 * @license    	GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
 * @email 		info@scorpioncomputers.nl
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class scorpionHtmlBuilder
{
    public function html(&$params)
    {
        // Start with setting the defaults
        $html = '';
        $elementID = '';
        $totalColums = 0;
        $paramsObject = $params->toObject();

        // Add a class string for each variable
        foreach ($paramsObject as $key => $value) {
            if (strval($key) == 'class') {
                if (!empty($value)) {
                    $html .= ' ' . $value;
                }
            } elseif (strval($key) == 'id') {
                if (!empty($value)) {
                    $elementID = 'id="' . $value . '" ';
                }
            } elseif (intval($value) > 0) { // And the rest should be columns with numeric values
                if ($this->$totalColums == 0) {
                    $html .= 'col-' . strval($key) . '-' . $value;
                } else {
                    $html .= ' col-' . strval($key) . '-' . $value;
                }
            }
            $this->$totalColums += intval($value);
        }

        // If all column values are zero, then just add a col class
        if ($this->$totalColums == 0) {
            $html = 'col';
        }

        // Let's remove the base in the class
        $html = str_replace('-base', '', $html);
        // And complete the html element that needs to be rendered
        $html = '<div ' . $elementID . 'class="' . $html . '">';

        return $html;
    }
}
