<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;

// Get opening hours ID from input or use default
$app = Factory::getApplication();
$openingHoursId = $app->input->getInt('id', null);

// Adding the helper to use all the extra functionality
require_once JPATH_COMPONENT . '/helpers/scorpionopeninghours.php';
$helper = new ScorpionopeninghoursHelper($openingHoursId, 'component', 'shorttext');

// Now we will generate specific styling for this template/layout
$extraStyle = '';
// Once we've set all the additional styling, add it to the document
$helper->addBasicCSS();
$helper->addExtraCSS($extraStyle);
$helper->addBasicHTML('start', 'shorttext');

// Now we are going to display if we are opened or closed
$htmlCode = '';
$htmlCode .= '<div class="shorttext">';
if($helper->areWeOpenNow()) {
    $htmlCode .= '<i class="fa fa-clock-o '.$helper->getOpenClosedClass().'"></i>';
} else {
    $htmlCode .= '<i class="fa fa-ban '.$helper->getOpenClosedClass().'"></i>';
}
$htmlCode .= $helper->getFieldValue('all_in_one_line', 'We are closed');
$htmlCode .= '</div>'."\r\n";

echo $htmlCode;

$helper->addBasicHTML('end');
// End of the code
?>
