<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;

// Get opening hours ID from input or use default
$app = Factory::getApplication();
$openingHoursId = $app->input->getInt('id', null);
$template = $app->input->getCmd('tmpl', 'default');

// Adding the helper to use all the extra functionality
require_once JPATH_COMPONENT . '/helpers/scorpionopeninghours.php';
$helper = new ScorpionopeninghoursHelper($openingHoursId, 'component', $template);

// Now we will generate specific styling for this template/layout
$extraStyle = '';
$htmlCode = '';
// Once we've set all the additional styling, add it to the document
$helper->addBasicCSS();
$helper->addExtraCSS($extraStyle);
$helper->addBasicHTML('start', 'default');

// Now we set the HTML-code that needs to be implemented for this template/layout
$htmlCode .= $helper->getAdditionalTextHTML('before');

$htmlCode .= '<div class="scs-openinghours-list">';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(1).'">';
$htmlCode .= '<div class="day-text">'.Text::_('MONDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(1).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(2).'">';
$htmlCode .= '<div class="day-text">'.Text::_('TUESDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(2).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(3).'">';
$htmlCode .= '<div class="day-text">'.Text::_('WEDNESDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(3).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(4).'">';
$htmlCode .= '<div class="day-text">'.Text::_('THURSDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(4).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(5).'">';
$htmlCode .= '<div class="day-text">'.Text::_('FRIDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(5).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(6).'">';
$htmlCode .= '<div class="day-text">'.Text::_('SATURDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(6).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(7).'">';
$htmlCode .= '<div class="day-text">'.Text::_('SUNDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(7).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '</div>';

$htmlCode .= $helper->getAdditionalTextHTML('after');

// Add additional opening hours if enabled
if ($helper->getFieldValue('show_future_additional_hours', true)) {
    $htmlCode .= '<hr/>';
    $htmlCode .= $helper->getAdditionalOpeningHoursHTML();
}

echo $htmlCode;

$helper->addBasicHTML('end');
// End of the code
?>
