<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;

/**
 * View class for a list of opening hours.
 */
class ScorpionopeninghoursViewOpeninghours extends HtmlView implements CurrentUserInterface
{
    use CurrentUserTrait;
    /**
     * An array of items
     *
     * @var  array
     */
    protected $items;

    /**
     * The pagination object
     *
     * @var  JPagination
     */
    protected $pagination;

    /**
     * The model state
     *
     * @var  object
     */
    protected $state;

    /**
     * Form object for search filters
     *
     * @var  JForm
     */
    public $filterForm;

    /**
     * The active search filters
     *
     * @var  array
     */
    public $activeFilters;

    /**
     * Display the view
     *
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @return  void
     */
    public function display($tpl = null)
    {
        $this->items         = $this->get('Items');
        $this->pagination    = $this->get('Pagination');
        $this->state         = $this->get('State');
        $this->filterForm    = $this->get('FilterForm');
        $this->activeFilters = $this->get('ActiveFilters');

        // Check for errors.
        if (count($errors = $this->get('Errors')))
        {
            throw new Exception(implode("\n", $errors), 500);
        }

        $this->addToolbar();

        parent::display($tpl);
    }

    /**
     * Add the page title and toolbar.
     *
     * @return  void
     */
    protected function addToolbar()
    {
        $canDo = ContentHelper::getActions('com_scorpionopeninghours');
        $user  = $this->getCurrentUser();

        ToolbarHelper::title(Text::_('COM_SCORPIONOPENINGHOURS_MANAGER_OPENINGHOURS'), 'calendar');

        if ($canDo->get('core.create'))
        {
            ToolbarHelper::addNew('openinghour.add');
        }

        if ($canDo->get('core.edit.state'))
        {
            ToolbarHelper::publish('openinghours.publish', 'JTOOLBAR_PUBLISH', true);
            ToolbarHelper::unpublish('openinghours.unpublish', 'JTOOLBAR_UNPUBLISH', true);
            ToolbarHelper::archiveList('openinghours.archive');
        }

        if ($canDo->get('core.create'))
        {
            ToolbarHelper::custom('openinghours.duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
        }

        if ($this->state->get('filter.published') == -2 && $canDo->get('core.delete'))
        {
            ToolbarHelper::deleteList('JGLOBAL_CONFIRM_DELETE', 'openinghours.delete', 'JTOOLBAR_EMPTY_TRASH');
        }
        elseif ($canDo->get('core.edit.state'))
        {
            ToolbarHelper::trash('openinghours.trash');
        }

        if ($canDo->get('core.admin') || $canDo->get('core.options'))
        {
            ToolbarHelper::preferences('com_scorpionopeninghours');
        }

        ToolbarHelper::help('JHELP_COMPONENTS_SCORPIONOPENINGHOURS_OPENINGHOURS');
    }
}
