<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;

/**
 * View to edit an opening hour.
 */
class ScorpionopeninghoursViewOpeninghour extends HtmlView implements CurrentUserInterface
{
    use CurrentUserTrait;
    /**
     * The JForm object
     *
     * @var  JForm
     */
    protected $form;

    /**
     * The active item
     *
     * @var  object
     */
    protected $item;

    /**
     * The model state
     *
     * @var  object
     */
    protected $state;

    /**
     * Display the view
     *
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @return  void
     */
    public function display($tpl = null)
    {
        $this->form  = $this->get('Form');
        $this->item  = $this->get('Item');
        $this->state = $this->get('State');

        // Check for errors.
        if (count($errors = $this->get('Errors')))
        {
            throw new Exception(implode("\n", $errors), 500);
        }

        $this->addToolbar();

        parent::display($tpl);
    }

    /**
     * Add the page title and toolbar.
     *
     * @return  void
     */
    protected function addToolbar()
    {
        Factory::getApplication()->input->set('hidemainmenu', true);

        $user       = $this->getCurrentUser();
        $isNew      = ($this->item->id == 0);
        $checkedOut = !(is_null($this->item->checked_out) || $this->item->checked_out == $user->get('id'));

        // Since we don't track these assets at the item level, use the category id.
        $canDo = ContentHelper::getActions('com_scorpionopeninghours', 'openinghour', $this->item->id);

        ToolbarHelper::title(
            Text::_('COM_SCORPIONOPENINGHOURS_MANAGER_OPENINGHOUR_' . ($checkedOut ? 'VIEW' : ($isNew ? 'NEW' : 'EDIT'))),
            'calendar'
        );

        // For new records, check the create permission.
        if ($isNew && (count($user->getAuthorisedCategories('com_scorpionopeninghours', 'core.create')) > 0))
        {
            ToolbarHelper::apply('openinghour.apply');
            ToolbarHelper::save('openinghour.save');
            ToolbarHelper::save2new('openinghour.save2new');
        }
        elseif (!$checkedOut && ($canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by == $user->id)))
        {
            ToolbarHelper::apply('openinghour.apply');
            ToolbarHelper::save('openinghour.save');

            if ($canDo->get('core.create'))
            {
                ToolbarHelper::save2new('openinghour.save2new');
                ToolbarHelper::save2copy('openinghour.save2copy');
            }
        }

        if (empty($this->item->id))
        {
            ToolbarHelper::cancel('openinghour.cancel');
        }
        else
        {
            ToolbarHelper::cancel('openinghour.cancel', 'JTOOLBAR_CLOSE');
        }

        ToolbarHelper::divider();
        ToolbarHelper::help('JHELP_COMPONENTS_SCORPIONOPENINGHOURS_OPENINGHOURS_EDIT');
    }
}
