<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Factory;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');
HTMLHelper::_('formbehavior.chosen', '#jform_access', null, array('disable_search_threshold' => 0));

$app = Factory::getApplication();
$input = $app->input;
?>

<form action="<?php echo Route::_('index.php?option=com_scorpionopeninghours&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">

    <?php echo LayoutHelper::render('joomla.edit.title_alias', $this); ?>

    <div class="main-card">
        <?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'details')); ?>

        <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'details', Text::_('COM_SCORPIONOPENINGHOURS_TAB_DETAILS')); ?>
        <div class="row">
            <div class="col-lg-9">
                <div class="card">
                    <div class="card-body">
                        <?php echo $this->form->renderField('description'); ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <?php echo $this->form->renderField('state'); ?>
                        <?php echo $this->form->renderField('access'); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php echo HTMLHelper::_('uitab.endTab'); ?>

        <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'regular_hours', Text::_('COM_SCORPIONOPENINGHOURS_TAB_REGULAR_HOURS')); ?>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <?php echo $this->form->renderField('timezone'); ?>
                        <?php echo $this->form->renderField('highlight_today'); ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo $this->form->renderField('monday_times'); ?>
                                <?php echo $this->form->renderField('tuesday_times'); ?>
                                <?php echo $this->form->renderField('wednesday_times'); ?>
                                <?php echo $this->form->renderField('thursday_times'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo $this->form->renderField('friday_times'); ?>
                                <?php echo $this->form->renderField('saturday_times'); ?>
                                <?php echo $this->form->renderField('sunday_times'); ?>
                                <?php echo $this->form->renderField('all_in_one_line'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo HTMLHelper::_('uitab.endTab'); ?>

        <?php /* Additional Hours tab removed as requested */ ?>

        <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'texts', Text::_('COM_SCORPIONOPENINGHOURS_TAB_TEXTS')); ?>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo $this->form->renderField('open_text'); ?>
                                <?php echo $this->form->renderField('closed_text'); ?>
                                <?php echo $this->form->renderField('pre_open_closed_text'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo $this->form->renderField('use_text_before'); ?>
                                <?php echo $this->form->renderField('text_before'); ?>
                                <?php echo $this->form->renderField('use_text_after'); ?>
                                <?php echo $this->form->renderField('text_after'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo HTMLHelper::_('uitab.endTab'); ?>


        <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'metadata', Text::_('JGLOBAL_FIELDSET_METADATA_OPTIONS')); ?>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo $this->form->renderField('created'); ?>
                                <?php echo $this->form->renderField('created_by'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo $this->form->renderField('modified'); ?>
                                <?php echo $this->form->renderField('modified_by'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo HTMLHelper::_('uitab.endTab'); ?>

        <?php echo HTMLHelper::_('uitab.endTabSet'); ?>
    </div>

    <input type="hidden" name="task" value="">
    <?php echo HTMLHelper::_('form.token'); ?>
</form>
