<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;

/**
 * View to edit an additional hour.
 */
class ScorpionopeninghoursViewAdditionalhour extends HtmlView implements CurrentUserInterface
{
    use CurrentUserTrait;
    protected $state;
    protected $item;
    protected $form;

    /**
     * Display the view.
     *
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @return  void
     */
    public function display($tpl = null)
    {
        $this->state = $this->get('State');
        $this->item = $this->get('Item');
        $this->form = $this->get('Form');

        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors), 500);
        }

        $this->addToolbar();

        parent::display($tpl);
    }

    /**
     * Add the page title and toolbar.
     *
     * @return  void
     *
     * @throws  Exception
     */
    protected function addToolbar()
    {
        Factory::getApplication()->input->set('hidemainmenu', true);

        $user = $this->getCurrentUser();
        $isNew = ($this->item->id == 0);
        $checkedOut = !(is_null($this->item->checked_out) || $this->item->checked_out == $user->get('id'));

        // Since we don't track these assets at the item level, use the category id.
        $canDo = ContentHelper::getActions('com_scorpionopeninghours', 'additionalhour', $this->item->id);

        ToolbarHelper::title(
            Text::_('COM_SCORPIONOPENINGHOURS_ADDITIONAL_HOURS_MANAGER') . ': ' . ($checkedOut ? Text::_('COM_SCORPIONOPENINGHOURS_VIEW_ITEM') : ($isNew ? Text::_('JTOOLBAR_NEW') : Text::_('JTOOLBAR_EDIT'))),
            'calendar-plus'
        );

        // For new records, check the create permission.
        if ($isNew && (count($user->getAuthorisedCategories('com_scorpionopeninghours', 'core.create')) > 0)) {
            ToolbarHelper::apply('additionalhour.apply');
            ToolbarHelper::save('additionalhour.save');
            ToolbarHelper::save2new('additionalhour.save2new');
        } elseif (!$checkedOut && ($canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by == $user->id))) {
            // We can save the new record
            ToolbarHelper::apply('additionalhour.apply');
            ToolbarHelper::save('additionalhour.save');

            // We can save this record, but check the create permission to see if we can return to make a new one.
            if ($canDo->get('core.create')) {
                ToolbarHelper::save2new('additionalhour.save2new');
            }
        }

        // If checked out, we can still save
        if ($canDo->get('core.create')) {
            ToolbarHelper::save2copy('additionalhour.save2copy');
        }

        ToolbarHelper::cancel('additionalhour.cancel', 'JTOOLBAR_CLOSE');
    }
}
