<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Table\Table;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Application\ApplicationHelper;
use Joomla\CMS\String\PunycodeHelper;
use Joomla\CMS\Access\Access;
use Joomla\CMS\User\User;
use Joomla\CMS\Date\Date;
use Joomla\Registry\Registry;
use Joomla\CMS\Factory;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;

/**
 * Additional Hour table
 */
class ScorpionopeninghoursTableAdditionalhour extends Table implements CurrentUserInterface
{
    use CurrentUserTrait;
    /**
     * Constructor
     *
     * @param   JDatabaseDriver  $db  Database connector object
     */
    public function __construct($db)
    {
        $this->typeAlias = 'com_scorpionopeninghours.additionalhour';
        
        parent::__construct('#__scorpion_opening_hours_additional', 'id', $db);
    }

    /**
     * Method to compute the default name of the asset.
     * The default name is in the form table_name.id
     * where id is the value of the primary key of the table.
     *
     * @return  string
     */
    protected function _getAssetName()
    {
        $k = $this->_tbl_key;

        return $this->typeAlias . '.' . (int) $this->$k;
    }

    /**
     * Method to return the title to use for the asset table.
     *
     * @return  string
     */
    protected function _getAssetTitle()
    {
        return $this->title;
    }

    /**
     * Method to get the parent asset under which to register this one.
     * By default, all assets are registered to the ROOT node with ID,
     * which will default to 1 if none exists.
     * The extended class can define a table and id to lookup.  If the
     * asset does not exist it will be created.
     *
     * @param   Table   $table  A Table object for the asset parent.
     * @param   integer  $id     Id to look up
     *
     * @return  integer
     */
    protected function _getAssetParentId(Table $table = null, $id = null)
    {
        // We will retrieve the parent-asset from the Asset-table
        $assetParent = Table::getInstance('Asset');

        // Default: if no asset-parent can be found we take the global asset
        $assetParentId = $assetParent->getRootId();

        // The item has the component as asset-parent
        $assetParent->loadByName('com_scorpionopeninghours');

        // Return the found asset-parent-id
        if ($assetParent->id) {
            $assetParentId = $assetParent->id;
        }

        return $assetParentId;
    }

    /**
     * Overloaded bind function to pre-process the params.
     *
     * @param   array  $array   Named array
     * @param   mixed  $ignore  Optional array or list of parameters to ignore
     *
     * @return  boolean  True on success.
     */
    public function bind($array, $ignore = '')
    {
        if (isset($array['params']) && is_array($array['params'])) {
            $registry = new Registry($array['params']);
            $array['params'] = (string) $registry;
        }

        return parent::bind($array, $ignore);
    }

    /**
     * Overloaded check function
     *
     * @return  boolean  True on success, false on failure
     */
    public function check()
    {
        try {
            parent::check();
        } catch (\Exception $e) {
            $this->setError($e->getMessage());
            return false;
        }

        // Check for valid name
        if (trim($this->title) == '') {
            $this->setError(Text::_('COM_SCORPIONOPENINGHOURS_ERROR_TITLE_REQUIRED'));
            return false;
        }

        // Generate a valid alias
        if (trim($this->alias) == '') {
            $this->alias = $this->title;
        }

        $this->alias = ApplicationHelper::stringURLSafe($this->alias, $this->language);

        if (trim(str_replace('-', '', $this->alias)) == '') {
            $this->alias = Factory::getDate()->format('Y-m-d-H-i-s');
        }

        // Check for valid dates
        if (empty($this->date_from)) {
            $this->setError(Text::_('COM_SCORPIONOPENINGHOURS_ERROR_DATE_FROM_REQUIRED'));
            return false;
        }

        if (empty($this->date_to)) {
            $this->setError(Text::_('COM_SCORPIONOPENINGHOURS_ERROR_DATE_TO_REQUIRED'));
            return false;
        }

        // Ensure date_to is not before date_from
        $dateFrom = new Date($this->date_from);
        $dateTo = new Date($this->date_to);

        if ($dateTo->toUnix() < $dateFrom->toUnix()) {
            $this->setError(Text::_('COM_SCORPIONOPENINGHOURS_ERROR_DATE_TO_BEFORE_FROM'));
            return false;
        }

        // Check for valid times if not fullday and open
        if ($this->open_or_closed === 'open' && $this->fullday != 1) {
            if (empty($this->start_time)) {
                $this->setError(Text::_('COM_SCORPIONOPENINGHOURS_ERROR_START_TIME_REQUIRED'));
                return false;
            }

            if (empty($this->end_time)) {
                $this->setError(Text::_('COM_SCORPIONOPENINGHOURS_ERROR_END_TIME_REQUIRED'));
                return false;
            }
        }

        return true;
    }

    /**
     * Overrides Table::store to set modified data and user id.
     *
     * @param   boolean  $updateNulls  True to update fields even if they are null.
     *
     * @return  boolean  True on success.
     */
    public function store($updateNulls = true)
    {
        $date = Factory::getDate();
        $user = $this->getCurrentUser();

        $this->modified = $date->toSql();
        $this->modified_by = $user->get('id');

        if (!(int) $this->created) {
            $this->created = $date->toSql();
            $this->created_by = $user->get('id');
        }

        // Verify that the alias is unique
        $table = Table::getInstance('Additionalhour', 'ScorpionopeninghoursTable', array('dbo' => $this->getDbo()));

        if ($table->load(array('alias' => $this->alias)) && ($table->id != $this->id || $this->id == 0)) {
            $this->setError(Text::_('COM_SCORPIONOPENINGHOURS_ERROR_UNIQUE_ALIAS'));
            return false;
        }

        return parent::store($updateNulls);
    }
}
