-- Version 2.1.3 - Follow Joomla standards with 'published' column
-- This script ensures the additional hours table follows Joomla conventions
-- Note: MySQL doesn't support IF EXISTS/IF NOT EXISTS in ALTER TABLE statements

-- Remove old foreign key constraints and columns first
-- These will fail gracefully if objects don't exist
ALTER TABLE `#__scorpion_opening_hours_additional` DROP FOREIGN KEY `fk_additional_opening_hours`;
ALTER TABLE `#__scorpion_opening_hours_additional` DROP INDEX `idx_opening_hours_id`;
ALTER TABLE `#__scorpion_opening_hours_additional` DROP COLUMN `opening_hours_id`;

-- Remove future hours fields from main opening hours table (moved to module)
ALTER TABLE `#__scorpion_opening_hours` DROP COLUMN `show_future_additional_hours`;
ALTER TABLE `#__scorpion_opening_hours` DROP COLUMN `number_future_additional_hours`;

-- Note: state->published rename removed - database already uses published column
-- Note: idx_state drop removed - database already uses idx_published index

-- Ensure published index exists on main opening hours table
ALTER TABLE `#__scorpion_opening_hours` ADD INDEX `idx_published` (`published`);

-- Add required columns (will fail if columns already exist, which is acceptable)
ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `title` varchar(255) NOT NULL DEFAULT '' AFTER `id`;

ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '' AFTER `title`;

-- Note: state->published rename removed - database already uses published column

ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `access` int(11) NOT NULL DEFAULT 1 AFTER `published`;

ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `checked_out` int(11) NOT NULL DEFAULT 0 AFTER `modified_by`;

ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' AFTER `checked_out`;

-- Update indexes (will fail gracefully if indexes already exist)
-- Note: idx_state drop removed - database already uses idx_published index
ALTER TABLE `#__scorpion_opening_hours_additional` ADD INDEX `idx_published` (`published`);
ALTER TABLE `#__scorpion_opening_hours_additional` ADD INDEX `idx_access` (`access`);
ALTER TABLE `#__scorpion_opening_hours_additional` ADD INDEX `idx_checkout` (`checked_out`);
ALTER TABLE `#__scorpion_opening_hours_additional` ADD INDEX `idx_alias` (`alias`(191));

-- Update any existing records to have proper titles and aliases
UPDATE `#__scorpion_opening_hours_additional` 
SET 
  `title` = CONCAT('Additional Hours ', `id`),
  `alias` = CONCAT('additional-hours-', `id`)
WHERE (`title` = '' OR `title` IS NULL) AND `id` > 0;
