-- Version 2.1.2 - Clean database update
-- This script ensures the additional hours table has the correct structure

-- First, let's recreate the additional hours table with the correct structure
DROP TABLE IF EXISTS `#__scorpion_opening_hours_additional_temp`;

CREATE TABLE `#__scorpion_opening_hours_additional_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `open_or_closed` enum('open','closed') NOT NULL DEFAULT 'closed',
  `fullday` tinyint(1) NOT NULL DEFAULT 0,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `reason` varchar(255) DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT 1,
  `access` int(11) NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_alias` (`alias`(191)),
  KEY `idx_date_from` (`date_from`),
  KEY `idx_date_to` (`date_to`),
  KEY `idx_createdby` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

-- Copy existing data if the original table exists
INSERT INTO `#__scorpion_opening_hours_additional_temp` 
  (`date_from`, `date_to`, `open_or_closed`, `fullday`, `start_time`, `end_time`, `reason`, `published`, `created`, `created_by`, `modified`, `modified_by`)
SELECT 
  `date_from`, 
  `date_to`, 
  `open_or_closed`, 
  `fullday`, 
  `start_time`, 
  `end_time`, 
  IFNULL(`reason`, ''),
  IFNULL(`state`, 1),
  IFNULL(`created`, NOW()),
  IFNULL(`created_by`, 0),
  IFNULL(`modified`, NOW()),
  IFNULL(`modified_by`, 0)
FROM `#__scorpion_opening_hours_additional`
WHERE EXISTS (SELECT 1 FROM `#__scorpion_opening_hours_additional` LIMIT 1);

-- Update title and alias for existing records
UPDATE `#__scorpion_opening_hours_additional_temp` 
SET 
  `title` = CONCAT('Additional Hours ', `id`),
  `alias` = CONCAT('additional-hours-', `id`)
WHERE `title` = '' OR `title` IS NULL;

-- Drop the original table and rename the temp table
DROP TABLE IF EXISTS `#__scorpion_opening_hours_additional`;
RENAME TABLE `#__scorpion_opening_hours_additional_temp` TO `#__scorpion_opening_hours_additional`;

-- Remove future hours fields from component (moved to module)
-- Note: MySQL doesn't support IF EXISTS in ALTER TABLE, these will fail gracefully if columns don't exist
ALTER TABLE `#__scorpion_opening_hours` DROP COLUMN `show_future_additional_hours`;
ALTER TABLE `#__scorpion_opening_hours` DROP COLUMN `number_future_additional_hours`;
