-- Remove future hours fields from component (moved to module)
-- Note: These columns may not exist in older versions
-- MySQL doesn't support IF EXISTS in ALTER TABLE, so these will fail gracefully if columns don't exist
ALTER TABLE `#__scorpion_opening_hours` DROP COLUMN `show_future_additional_hours`;
ALTER TABLE `#__scorpion_opening_hours` DROP COLUMN `number_future_additional_hours`;

-- Update additional hours table to be independent (remove foreign key constraint)
-- Note: These may not exist, errors are expected and can be ignored
ALTER TABLE `#__scorpion_opening_hours_additional` DROP FOREIGN KEY `fk_additional_opening_hours`;
ALTER TABLE `#__scorpion_opening_hours_additional` DROP INDEX `idx_opening_hours_id`;
ALTER TABLE `#__scorpion_opening_hours_additional` DROP COLUMN `opening_hours_id`;

-- Add new fields for independent additional hours management
-- These will fail if columns already exist, but that's acceptable for update scripts

-- Add title column (only if it doesn't exist - will fail gracefully if it does)
ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `title` varchar(255) NOT NULL DEFAULT '' AFTER `id`;

-- Add alias column  
ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '' AFTER `title`;

-- Note: state->published rename removed - database already uses published column

-- Add access column
ALTER TABLE `#__scorpion_opening_hours_additional`
ADD COLUMN `access` int(11) NOT NULL DEFAULT 1 AFTER `published`;

-- Add checked_out column
ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `checked_out` int(11) NOT NULL DEFAULT 0 AFTER `modified_by`;

-- Add checked_out_time column
ALTER TABLE `#__scorpion_opening_hours_additional` 
ADD COLUMN `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' AFTER `checked_out`;

-- Add new indexes (will fail gracefully if indexes already exist)
ALTER TABLE `#__scorpion_opening_hours_additional` ADD KEY `idx_access` (`access`);
ALTER TABLE `#__scorpion_opening_hours_additional` ADD KEY `idx_checkout` (`checked_out`);
ALTER TABLE `#__scorpion_opening_hours_additional` ADD KEY `idx_published` (`published`);
ALTER TABLE `#__scorpion_opening_hours_additional` ADD KEY `idx_alias` (`alias`(191));
