CREATE TABLE IF NOT EXISTS `#__scorpion_opening_hours` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `description` text,
  `timezone` varchar(100) NOT NULL DEFAULT 'Europe/Amsterdam',
  `highlight_today` tinyint(1) NOT NULL DEFAULT 1,
  `monday_times` varchar(255) NOT NULL DEFAULT '08:30 - 18:00',
  `tuesday_times` varchar(255) NOT NULL DEFAULT '08:30 - 18:00',
  `wednesday_times` varchar(255) NOT NULL DEFAULT '08:30 - 18:00',
  `thursday_times` varchar(255) NOT NULL DEFAULT '08:30 - 18:00',
  `friday_times` varchar(255) NOT NULL DEFAULT '08:30 - 18:00',
  `saturday_times` varchar(255) NOT NULL DEFAULT '08:30 - 18:00',
  `sunday_times` varchar(255) NOT NULL DEFAULT 'CLOSED',
  `all_in_one_line` varchar(500) NOT NULL DEFAULT 'mon-sat: 8:30 - 18:00',
  `open_text` varchar(100) NOT NULL DEFAULT 'OPEN',
  `closed_text` varchar(100) NOT NULL DEFAULT 'CLOSED',
  `pre_open_closed_text` varchar(100) NOT NULL DEFAULT 'We are',
  `use_text_before` tinyint(1) NOT NULL DEFAULT 0,
  `text_before` text,
  `use_text_after` tinyint(1) NOT NULL DEFAULT 0,
  `text_after` text,
  `published` tinyint(3) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(11) NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_published` (`published`),
  KEY `idx_alias` (`alias`(191)),
  KEY `idx_createdby` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__scorpion_opening_hours_additional` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `open_or_closed` enum('open','closed') NOT NULL DEFAULT 'closed',
  `fullday` tinyint(1) NOT NULL DEFAULT 0,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `reason` varchar(255) DEFAULT '',
  `published` tinyint(3) NOT NULL DEFAULT 1,
  `access` int(11) NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_published` (`published`),
  KEY `idx_alias` (`alias`(191)),
  KEY `idx_date_from` (`date_from`),
  KEY `idx_date_to` (`date_to`),
  KEY `idx_createdby` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

-- Insert default opening hours set
INSERT INTO `#__scorpion_opening_hours` (`title`, `alias`, `description`, `published`, `created`, `created_by`) VALUES
('Default Opening Hours', 'default-opening-hours', 'Default opening hours configuration', 1, NOW(), 0);
