<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Table\Table;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\String\PunycodeHelper;
use Joomla\CMS\Application\ApplicationHelper;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;

/**
 * Opening Hour Model
 */
class ScorpionopeninghoursModelOpeninghour extends AdminModel implements CurrentUserInterface
{
    use CurrentUserTrait;
    /**
     * The type alias for this content type.
     *
     * @var    string
     */
    public $typeAlias = 'com_scorpionopeninghours.openinghour';

    /**
     * Method to get the record form.
     *
     * @param   array    $data      Data for the form.
     * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
     *
     * @return  JForm|boolean  A JForm object on success, false on failure
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Get the form.
        $form = $this->loadForm('com_scorpionopeninghours.openinghour', 'openinghour', array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form))
        {
            return false;
        }

        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return  mixed  The data for the form.
     */
    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState('com_scorpionopeninghours.edit.openinghour.data', array());

        if (empty($data))
        {
            $data = $this->getItem();
        }

        $this->preprocessData('com_scorpionopeninghours.openinghour', $data);

        return $data;
    }

    /**
     * Method to get a table object, load it if necessary.
     *
     * @param   string  $type    The table name. Optional.
     * @param   string  $prefix  The class prefix. Optional.
     * @param   array   $config  Configuration array for model. Optional.
     *
     * @return  Table  A Table object
     */
    public function getTable($type = 'Openinghour', $prefix = 'ScorpionopeninghoursTable', $config = array())
    {
        return Table::getInstance($type, $prefix, $config);
    }

    /**
     * Method to save the form data.
     *
     * @param   array  $data  The form data.
     *
     * @return  boolean  True on success.
     */
    public function save($data)
    {
        $input = Factory::getApplication()->input;

        // Automatic handling of alias for empty fields
        if (in_array($input->get('task'), array('apply', 'save', 'save2new')) && (!isset($data['id']) || (int) $data['id'] == 0))
        {
            if ($data['alias'] == null)
            {
                if (Factory::getConfig()->get('unicodeslugs') == 1)
                {
                    $data['alias'] = PunycodeHelper::urlToUTF8($data['title']);
                }
                else
                {
                    $data['alias'] = $data['title'];
                }

                $data['alias'] = ApplicationHelper::stringURLSafe($data['alias'], Factory::getLanguage()->getTag());

                if (trim(str_replace('-', '', $data['alias'])) == '')
                {
                    $data['alias'] = Factory::getDate()->format('Y-m-d-H-i-s');
                }
            }
        }

        // Handle additional opening hours
        if (isset($data['additional_hours']) && is_array($data['additional_hours']))
        {
            // We'll handle this after the main record is saved
            $additionalHours = $data['additional_hours'];
            unset($data['additional_hours']);
        }

        if (parent::save($data))
        {
            $id = $this->getState($this->getName() . '.id');

            // Save additional opening hours
            if (isset($additionalHours))
            {
                $this->saveAdditionalHours($id, $additionalHours);
            }

            return true;
        }

        return false;
    }

    /**
     * Method to save additional opening hours
     *
     * @param   int    $openingHourId  The opening hour ID
     * @param   array  $additionalHours  The additional hours data
     *
     * @return  boolean  True on success
     */
    protected function saveAdditionalHours($openingHourId, $additionalHours)
    {
        $db = $this->getDbo();

        // First, delete existing additional hours for this opening hour
        $query = $db->getQuery(true)
            ->delete('#__scorpion_opening_hours_additional')
            ->where('opening_hours_id = ' . (int) $openingHourId);
        $db->setQuery($query);
        $db->execute();

        // Insert new additional hours
        foreach ($additionalHours as $hour)
        {
            if (empty($hour['date_from']) || empty($hour['date_to']))
            {
                continue;
            }

            $additionalHour = new stdClass();
            $additionalHour->opening_hours_id = $openingHourId;
            $additionalHour->date_from = $hour['date_from'];
            $additionalHour->date_to = $hour['date_to'];
            $additionalHour->open_or_closed = isset($hour['open_or_closed']) ? $hour['open_or_closed'] : 'closed';
            $additionalHour->fullday = isset($hour['fullday']) ? (int) $hour['fullday'] : 0;
            $additionalHour->start_time = isset($hour['start_time']) ? $hour['start_time'] : null;
            $additionalHour->end_time = isset($hour['end_time']) ? $hour['end_time'] : null;
            $additionalHour->reason = isset($hour['reason']) ? $hour['reason'] : '';
            $additionalHour->state = isset($hour['state']) ? (int) $hour['state'] : 1;
            $additionalHour->created = Factory::getDate()->toSql();
            $additionalHour->created_by = $this->getCurrentUser()->id;

            $db->insertObject('#__scorpion_opening_hours_additional', $additionalHour);
        }

        return true;
    }

    /**
     * Method to get a single record.
     *
     * @param   integer  $pk  The id of the primary key.
     *
     * @return  mixed  Object on success, false on failure.
     */
    public function getItem($pk = null)
    {
        $item = parent::getItem($pk);

        // Additional hours are now managed globally, not per opening hours set
        // No need to load them here anymore

        return $item;
    }

    /**
     * Method to duplicate one or more records.
     *
     * @param   array  &$pks  An array of primary key IDs.
     *
     * @return  boolean  True if successful.
     *
     * @throws  Exception
     */
    public function duplicate(&$pks)
    {
        $user = $this->getCurrentUser();
        $db = $this->getDbo();

        // Access checks.
        if (!$user->authorise('core.create', 'com_scorpionopeninghours'))
        {
            throw new Exception(Text::_('JERROR_CORE_CREATE_NOT_PERMITTED'));
        }

        $table = $this->getTable();

        foreach ($pks as $pk)
        {
            if ($table->load($pk, true))
            {
                // Reset the id to create a new record.
                $table->id = 0;

                // Alter the title.
                $m = null;
                if (preg_match('#\((\d+)\)$#', $table->title, $m))
                {
                    $table->title = preg_replace('#\(\d+\)$#', '(' . ($m[1] + 1) . ')', $table->title);
                }
                else
                {
                    $table->title .= ' (2)';
                }

                // Alter the alias.
                $m = null;
                if (preg_match('#\((\d+)\)$#', $table->alias, $m))
                {
                    $table->alias = preg_replace('#\(\d+\)$#', '(' . ($m[1] + 1) . ')', $table->alias);
                }
                else
                {
                    $table->alias .= '-2';
                }

                // Unset the checked out fields
                $table->checked_out = 0;
                $table->checked_out_time = null;

                // Reset creation date
                $table->created = Factory::getDate()->toSql();
                $table->created_by = $user->id;

                // Reset modification date
                $table->modified = Factory::getDate()->toSql();
                $table->modified_by = $user->id;

                // Reset state to unpublished
                $table->published = 0;

                // Check the row.
                if (!$table->check())
                {
                    throw new Exception($table->getError());
                }

                // Store the row.
                if (!$table->store())
                {
                    throw new Exception($table->getError());
                }
            }
            else
            {
                throw new Exception($table->getError());
            }
        }

        // Clean cache
        $this->cleanCache();

        return true;
    }
}
