<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Application\ApplicationHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;

/**
 * Additional Hour Model
 */
class ScorpionopeninghoursModelAdditionalhour extends AdminModel implements CurrentUserInterface
{
    use CurrentUserTrait;
    /**
     * The type alias for this content type.
     *
     * @var    string
     */
    public $typeAlias = 'com_scorpionopeninghours.additionalhour';

    /**
     * The prefix to use with controller messages.
     *
     * @var    string
     */
    protected $text_prefix = 'COM_SCORPIONOPENINGHOURS';

    /**
     * Method to get the record form.
     *
     * @param   array    $data      Data for the form.
     * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
     *
     * @return  Form|boolean  A Form object on success, false on failure
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Get the form.
        $form = $this->loadForm(
            'com_scorpionopeninghours.additionalhour',
            'additionalhour',
            array(
                'control' => 'jform',
                'load_data' => $loadData
            )
        );

        if (empty($form)) {
            return false;
        }

        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return  mixed  The data for the form.
     */
    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $app = Factory::getApplication();
        $data = $app->getUserState('com_scorpionopeninghours.edit.additionalhour.data', array());

        if (empty($data)) {
            $data = $this->getItem();
        }

        $this->preprocessData('com_scorpionopeninghours.additionalhour', $data);

        return $data;
    }

    /**
     * Method to get a table object, load it if necessary.
     *
     * @param   string  $name     The table name. Optional.
     * @param   string  $prefix   The class prefix. Optional.
     * @param   array   $options  Configuration array for model. Optional.
     *
     * @return  Table  A Table object
     */
    public function getTable($name = 'Additionalhour', $prefix = 'ScorpionopeninghoursTable', $options = array())
    {
        return Table::getInstance($name, $prefix, $options);
    }

    /**
     * Method to save the form data.
     *
     * @param   array  $data  The form data.
     *
     * @return  boolean  True on success.
     */
    public function save($data)
    {
        $input = Factory::getApplication()->input;

        // Automatic handling of alias for empty fields
        if (in_array($input->get('task'), array('apply', 'save', 'save2new')) && (!isset($data['id']) || (int) $data['id'] == 0)) {
            if ($data['alias'] == null) {
                if (Factory::getConfig()->get('unicodeslugs') == 1) {
                    $data['alias'] = ApplicationHelper::stringURLUnicodeSlug($data['title']);
                } else {
                    $data['alias'] = ApplicationHelper::stringURLSafe($data['title']);
                }

                $table = Table::getInstance('Additionalhour', 'ScorpionopeninghoursTable');

                if ($table->load(array('alias' => $data['alias']))) {
                    $msg = Text::_('COM_SCORPIONOPENINGHOURS_SAVE_WARNING');
                }

                list($title, $alias) = $this->generateNewTitle(0, $data['alias'], $data['title']);
                $data['alias'] = $alias;
                $data['title'] = $title;

                if (isset($msg)) {
                    Factory::getApplication()->enqueueMessage($msg, 'warning');
                }
            }
        }

        return parent::save($data);
    }

    /**
     * Method to change the title & alias.
     *
     * @param   integer  $category_id  The id of the parent.
     * @param   string   $alias        The alias.
     * @param   string   $title        The title.
     *
     * @return  array  Contains the modified title and alias.
     */
    protected function generateNewTitle($category_id, $alias, $title)
    {
        // Alter the title & alias
        $table = $this->getTable();

        while ($table->load(array('alias' => $alias))) {
            $title = ApplicationHelper::stringIncrement($title);
            $alias = ApplicationHelper::stringIncrement($alias, 'dash');
        }

        return array($title, $alias);
    }

    /**
     * Method to test whether a record can be deleted.
     *
     * @param   object  $record  A record object.
     *
     * @return  boolean  True if allowed to delete the record. Defaults to the permission for the component.
     */
    protected function canDelete($record)
    {
        if (empty($record->id) || ($record->state != -2)) {
            return false;
        }

        return $this->getCurrentUser()->authorise('core.delete', 'com_scorpionopeninghours.additionalhour.' . (int) $record->id);
    }

    /**
     * Method to test whether a record can have its state edited.
     *
     * @param   object  $record  A record object.
     *
     * @return  boolean  True if allowed to change the state of the record. Defaults to the permission for the component.
     */
    protected function canEditState($record)
    {
        $user = $this->getCurrentUser();

        // Check for existing additional hour.
        if (!empty($record->id)) {
            return $user->authorise('core.edit.state', 'com_scorpionopeninghours.additionalhour.' . (int) $record->id);
        }

        // Default to component settings if no additional hour id is known.
        return $user->authorise('core.edit.state', 'com_scorpionopeninghours');
    }

    /**
     * Prepare and sanitise the table prior to saving.
     *
     * @param   Table  $table  A Table object.
     *
     * @return  void
     */
    protected function prepareTable($table)
    {
        $date = Factory::getDate();
        $user = $this->getCurrentUser();

        if (empty($table->id)) {
            // Set the values
            $table->created = $date->toSql();
            $table->created_by = $user->id;

            // Set ordering to the last item if not set
            if (empty($table->ordering)) {
                $db = Factory::getDbo();
                $query = $db->getQuery(true)
                    ->select('MAX(ordering)')
                    ->from('#__scorpion_opening_hours_additional');

                $db->setQuery($query);
                $max = $db->loadResult();

                $table->ordering = $max + 1;
            }
        } else {
            // Set the values
            $table->modified = $date->toSql();
            $table->modified_by = $user->id;
        }

        // Increment the content version number.
        $table->version++;
    }
}
