<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Language\Text;

/**
 * Opening Hours list controller class.
 */
class ScorpionopeninghoursControllerOpeninghours extends AdminController
{
    /**
     * Method to get a model object, loading it if required.
     *
     * @param   string  $name    The model name. Optional.
     * @param   string  $prefix  The class prefix. Optional.
     * @param   array   $config  Configuration array for model. Optional.
     *
     * @return  JModelLegacy  The model.
     */
    public function getModel($name = 'Openinghour', $prefix = 'ScorpionopeninghoursModel', $config = array('ignore_request' => true))
    {
        return parent::getModel($name, $prefix, $config);
    }

    /**
     * Method to duplicate records.
     *
     * @return  void
     *
     * @throws  Exception
     */
    public function duplicate()
    {
        // Check for request forgeries
        $this->checkToken();

        $ids = $this->input->get('cid', array(), 'array');

        if (empty($ids))
        {
            $this->app->enqueueMessage(Text::_('COM_SCORPIONOPENINGHOURS_NO_ITEM_SELECTED'), 'warning');
        }
        else
        {
            // Get the model.
            $model = $this->getModel();

            // Make sure the item ids are integers
            $ids = array_map('intval', $ids);

            // Duplicate the items.
            if ($model->duplicate($ids))
            {
                $this->setMessage(Text::plural('COM_SCORPIONOPENINGHOURS_N_ITEMS_DUPLICATED', count($ids)));
            }
            else
            {
                $this->setMessage($model->getError(), 'error');
            }
        }

        $this->setRedirect('index.php?option=com_scorpionopeninghours&view=openinghours');
    }
}
