<?php
/**
 * @package     Scorpion Opening Hours
 * @subpackage  com_scorpionopeninghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

/**
 * Opening Hour controller class.
 */
class ScorpionopeninghoursControllerOpeninghour extends FormController implements CurrentUserInterface
{
    use CurrentUserTrait;
    /**
     * Method to check if you can add a new record.
     *
     * @param   array  $data  An array of input data.
     *
     * @return  boolean
     */
    protected function allowAdd($data = array())
    {
        return parent::allowAdd($data);
    }

    /**
     * Method to check if you can edit a record.
     *
     * @param   array   $data  An array of input data.
     * @param   string  $key   The name of the key for the primary key.
     *
     * @return  boolean
     */
    protected function allowEdit($data = array(), $key = 'id')
    {
        $recordId = (int) isset($data[$key]) ? $data[$key] : 0;
        $user = $this->getCurrentUser();

        // Check general edit permission first.
        if ($user->authorise('core.edit', 'com_scorpionopeninghours.openinghour.' . $recordId))
        {
            return true;
        }

        // Fallback on edit.own.
        // First test if the permission is available.
        if ($user->authorise('core.edit.own', 'com_scorpionopeninghours.openinghour.' . $recordId))
        {
            // Now test the owner is the user.
            $ownerId = (int) isset($data['created_by']) ? $data['created_by'] : 0;

            if (empty($ownerId) && $recordId)
            {
                // Need to do a lookup from the model.
                $record = $this->getModel()->getItem($recordId);

                if (empty($record))
                {
                    return false;
                }

                $ownerId = $record->created_by;
            }

            // If the owner matches 'me' then do the test.
            if ($ownerId == $user->get('id'))
            {
                return true;
            }
        }

        return parent::allowEdit($data, $key);
    }

    /**
     * Method to save a record.
     *
     * @param   string  $key     The name of the primary key of the URL variable.
     * @param   string  $urlVar  The name of the URL variable if different from the primary key (sometimes required to avoid router collisions).
     *
     * @return  boolean  True if successful, false otherwise.
     */
    public function save2copy($key = null, $urlVar = null)
    {
        // Check for request forgeries.
        $this->checkToken();

        $app   = Factory::getApplication();
        $model = $this->getModel();
        $table = $model->getTable();
        $data  = $this->input->post->get('jform', array(), 'array');
        $checkin = property_exists($table, 'checked_out');
        $context = "$this->option.edit.$this->context";
        $task = $this->getTask();

        // Determine the name of the primary key for the data.
        if (empty($key))
        {
            $key = $table->getKeyName();
        }

        // To avoid data collisions the urlVar may be different from the primary key.
        if (empty($urlVar))
        {
            $urlVar = $key;
        }

        $recordId = $this->input->getInt($urlVar);

        // Populate the row id from the session.
        $data[$key] = $recordId;

        // Access check.
        if (!$this->allowSave($data, $key))
        {
            $this->setError(Text::_('JLIB_APPLICATION_ERROR_SAVE_NOT_PERMITTED'));
            $this->setMessage($this->getError(), 'error');

            $this->setRedirect(
                Route::_(
                    'index.php?option=' . $this->option . '&view=' . $this->view_list
                    . $this->getRedirectToListAppend(),
                    false
                )
            );

            return false;
        }

        // The save2copy task needs to be handled slightly differently.
        // Load the existing record data
        if (!$table->load($recordId))
        {
            $this->setError(Text::sprintf('JLIB_APPLICATION_ERROR_LOAD_FAILED', $table->getError()));
            $this->setMessage($this->getError(), 'error');

            $this->setRedirect(
                Route::_(
                    'index.php?option=' . $this->option . '&view=' . $this->view_list
                    . $this->getRedirectToListAppend(),
                    false
                )
            );

            return false;
        }

        // Reset the id to create a new record.
        $data = $table->getProperties();
        $data['id'] = 0;

        // Alter the title.
        $m = null;
        if (preg_match('#\((\d+)\)$#', $data['title'], $m))
        {
            $data['title'] = preg_replace('#\(\d+\)$#', '(' . ($m[1] + 1) . ')', $data['title']);
        }
        else
        {
            $data['title'] .= ' (2)';
        }

        // Alter the alias.
        $m = null;
        if (preg_match('#\((\d+)\)$#', $data['alias'], $m))
        {
            $data['alias'] = preg_replace('#\(\d+\)$#', '(' . ($m[1] + 1) . ')', $data['alias']);
        }
        else
        {
            $data['alias'] .= '-2';
        }

        // Reset creation and modification dates
        $data['created'] = Factory::getDate()->toSql();
        $data['created_by'] = $this->getCurrentUser()->id;
        $data['modified'] = Factory::getDate()->toSql();
        $data['modified_by'] = $this->getCurrentUser()->id;

        // Reset state to unpublished
        $data['published'] = 0;

        // Reset checked out fields
        $data['checked_out'] = 0;
        $data['checked_out_time'] = null;

        // Save the data using the model
        if (!$model->save($data))
        {
            $this->setError(Text::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', $model->getError()));
            $this->setMessage($this->getError(), 'error');

            $this->setRedirect(
                Route::_(
                    'index.php?option=' . $this->option . '&view=' . $this->view_item
                    . $this->getRedirectToItemAppend($key, $recordId),
                    false
                )
            );

            return false;
        }

        // Clean the session data.
        $app->setUserState($context . '.data', null);

        $this->setMessage(Text::_('COM_SCORPIONOPENINGHOURS_ITEM_SAVED_SUCCESSFULLY'));

        // Get the new record ID
        $newId = $model->getState($model->getName() . '.id');

        // Redirect the user and adjust session state based on the chosen task.
        $this->setRedirect(
            Route::_(
                'index.php?option=' . $this->option . '&view=' . $this->view_item
                . $this->getRedirectToItemAppend($key, $newId),
                false
            )
        );

        return true;
    }
}
