<?php
/**
 * @package     Scorpion Opening Hours Package
 * @subpackage  pkg_scorpion_openinghours
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;

/**
 * Installation class to perform additional changes during install/uninstall/update
 */
class Pkg_Scorpion_OpeninghoursInstallerScript
{
    /**
     * The minimum Joomla version required to install this package
     *
     * @var    string
     */
    protected $minimumJoomla = '3.9.0';

    /**
     * The minimum PHP version required to install this package
     *
     * @var    string
     */
    protected $minimumPhp = '7.4.0';

    /**
     * Function called before package installation/update/removal procedure commences
     *
     * @param   string                     $type    The type of change (install, update or discover_install, not uninstall)
     * @param   JInstallerAdapterPackage   $parent  The class calling this method
     *
     * @return  boolean  True on success
     */
    public function preflight($type, $parent)
    {
        // Check for the minimum Joomla version before continuing
        if (!empty($this->minimumJoomla) && version_compare(JVERSION, $this->minimumJoomla, '<'))
        {
            Log::add(Text::sprintf('PKG_SCORPIONOPENINGHOURS_MININUM_JOOMLA_VERSION', $this->minimumJoomla), Log::WARNING, 'jerror');
            return false;
        }

        // Check for the minimum PHP version before continuing
        if (!empty($this->minimumPhp) && version_compare(PHP_VERSION, $this->minimumPhp, '<'))
        {
            Log::add(Text::sprintf('PKG_SCORPIONOPENINGHOURS_MININUM_PHP_VERSION', $this->minimumPhp), Log::WARNING, 'jerror');
            return false;
        }

        return true;
    }

    /**
     * Function called after package installation/update/removal procedure commences
     *
     * @param   string                     $type    The type of change (install, update or discover_install, not uninstall)
     * @param   JInstallerAdapterPackage   $parent  The class calling this method
     *
     * @return  boolean  True on success
     */
    public function postflight($type, $parent)
    {
        if ($type == 'install')
        {
            $this->displayInstallationMessage();
        }
        elseif ($type == 'update')
        {
            $this->displayUpdateMessage();
        }

        return true;
    }

    /**
     * Function called when package is uninstalled
     *
     * @param   JInstallerAdapterPackage  $parent  The class calling this method
     *
     * @return  boolean  True on success
     */
    public function uninstall($parent)
    {
        echo '<h2>' . Text::_('PKG_SCORPIONOPENINGHOURS_UNINSTALL_TITLE') . '</h2>';
        echo '<p>' . Text::_('PKG_SCORPIONOPENINGHOURS_UNINSTALL_MESSAGE') . '</p>';
        
        return true;
    }

    /**
     * Display installation success message
     */
    private function displayInstallationMessage()
    {
        echo '<div style="background-color: #dff0d8; border: 1px solid #d6e9c6; color: #3c763d; padding: 15px; margin: 20px 0; border-radius: 4px;">';
        echo '<h2 style="margin-top: 0;">' . Text::_('PKG_SCORPIONOPENINGHOURS_INSTALL_SUCCESS_TITLE') . '</h2>';
        echo '<p>' . Text::_('PKG_SCORPIONOPENINGHOURS_INSTALL_SUCCESS_MESSAGE') . '</p>';
        echo '<h3>' . Text::_('PKG_SCORPIONOPENINGHOURS_NEXT_STEPS_TITLE') . '</h3>';
        echo '<ol>';
        echo '<li>' . Text::_('PKG_SCORPIONOPENINGHOURS_STEP_1') . '</li>';
        echo '<li>' . Text::_('PKG_SCORPIONOPENINGHOURS_STEP_2') . '</li>';
        echo '<li>' . Text::_('PKG_SCORPIONOPENINGHOURS_STEP_3') . '</li>';
        echo '<li>' . Text::_('PKG_SCORPIONOPENINGHOURS_STEP_4') . '</li>';
        echo '</ol>';
        echo '<p><strong>' . Text::_('PKG_SCORPIONOPENINGHOURS_SUPPORT_MESSAGE') . '</strong></p>';
        echo '</div>';
    }

    /**
     * Display update success message
     */
    private function displayUpdateMessage()
    {
        echo '<div style="background-color: #d9edf7; border: 1px solid #bce8f1; color: #31708f; padding: 15px; margin: 20px 0; border-radius: 4px;">';
        echo '<h2 style="margin-top: 0;">' . Text::_('PKG_SCORPIONOPENINGHOURS_UPDATE_SUCCESS_TITLE') . '</h2>';
        echo '<p>' . Text::_('PKG_SCORPIONOPENINGHOURS_UPDATE_SUCCESS_MESSAGE') . '</p>';
        echo '<p><strong>' . Text::_('PKG_SCORPIONOPENINGHOURS_UPDATE_NOTE') . '</strong></p>';
        echo '</div>';
    }
}
