<?php
/**
 * @package     Scorpion Opening Hours Next
 * @subpackage  mod_scorpion_openinghours_next
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 * This template is mainly used for development purposes
 * It can give inspiration to developers to create their own templates 
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

// Now we will generate specific styling according to the parameters
$extraStyle = '';
$htmlCode = '';

// Once we've set all the additional styling, add it to the document
$helper->addBasicCSS();
$helper->addExtraCSS($extraStyle);
$helper->addBasicHTML('start', 'inspiration');

// Just add some potentially useful information to display on the screen
$htmlCode .= '<strong>Template: </strong>inspiration<br/>'."\r\n";
$currentTime = new DateTime('now', new DateTimeZone($helper->getUsersOrSelectedTimezone()));
if (date_default_timezone_get()) {
    $htmlCode .= '<strong>System Timezone: </strong>' . date_default_timezone_get() .'<br/>'."\r\n";
}
$htmlCode .= '<strong>Selected Timezone: </strong>' . $helper->getFieldValue('timezone', 'Europe/Amsterdam') . '<br/>'."\r\n";
// If a user has set his timezone in Joomla, it might give a different result
$htmlCode .= '<strong>User or Selected Timezone: </strong>' . $helper->getUsersOrSelectedTimezone() . '<br/>'."\r\n";
$dateString = date_format($currentTime, 'd/m/Y H:i:s');
$htmlCode .= '<p><strong>Current calculated time: </strong>' . $dateString . "\r\n";
$htmlCode .= '<hr/>';

// Some info about the user that might be logged in
$currentUser = Factory::getApplication()->getIdentity();
if($currentUser->id <> 0) {
    $htmlCode .= '<strong>Current id: </strong>' . $currentUser->id . '<br/>'."\r\n";
    $htmlCode .= '<strong>Current user: </strong>' . $currentUser->name . '<br/>'."\r\n";
    $htmlCode .= '<strong>Current timezone: </strong>' . $currentUser->getParam('timezone') . '<br/>'."\r\n";
    $htmlCode .= '<hr/>';
}

// Add the rest of the code here
$htmlCode .= $helper->getAdditionalTextHTML('before');

$htmlCode .= '<div class="scs-openinghours-list">';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(1).'">';
$htmlCode .= '<div class="day-text">'.Text::_('MONDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(1).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(2).'">';
$htmlCode .= '<div class="day-text">'.Text::_('TUESDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(2).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(3).'">';
$htmlCode .= '<div class="day-text">'.Text::_('WEDNESDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(3).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(4).'">';
$htmlCode .= '<div class="day-text">'.Text::_('THURSDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(4).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(5).'">';
$htmlCode .= '<div class="day-text">'.Text::_('FRIDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(5).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(6).'">';
$htmlCode .= '<div class="day-text">'.Text::_('SATURDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(6).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '<div class="each-day '.$helper->getCurrentDayClass(7).'">';
$htmlCode .= '<div class="day-text">'.Text::_('SUNDAY').'</div><div class="day-time">'.$helper->getCurrentDayOpeningtimes(7).'</div>'."\r\n";
$htmlCode .= '</div>';
$htmlCode .= '</div>';

$htmlCode .= $helper->getAdditionalTextHTML('after');

// Now we are going to display if we are opened or closed
$htmlCode .= '<hr/>';
$htmlCode .= '<div class="open-or-not text-center">';
$htmlCode .= $helper->getOpenClosedText();
$htmlCode .= '</div>'."\r\n";

// Add additional opening hours if enabled
if ($helper->getFieldValue('show_future_additional_hours', true)) {
    $htmlCode .= '<hr/>';
    
    // Debug information
    $additionalHoursData = $helper->getAdditionalOpeningHours();
    $htmlCode .= '<strong>Debug - Show Future Setting: </strong>' . $helper->getFieldValue('show_future_additional_hours', true) . '<br/>';
    $htmlCode .= '<strong>Debug - Number to Show: </strong>' . $helper->getFieldValue('number_future_additional_hours', 3) . '<br/>';
    $htmlCode .= '<strong>Debug - Additional Hours Count: </strong>' . count($additionalHoursData) . '<br/>';
    
    $htmlCode .= $helper->getAdditionalOpeningHoursHTML();
}

echo $htmlCode;

$helper->addBasicHTML('end');
// End of the code
?>
