<?php
/**
 * @package     Scorpion Opening Hours Next
 * @subpackage  mod_scorpion_openinghours_next
 * @author      Scorpion Computers and Software
 * @copyright   Copyright (C) Scorpion Computers and Software. All rights reserved.
 * @license     GNU General Public License version 2 or later
 * @email       info@ScorpionComputers.nl
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;

// Check if the component is installed and enabled
if (!ComponentHelper::isEnabled('com_scorpionopeninghours')) {
    echo '<div class="alert alert-warning">Scorpion Opening Hours Component is not installed or enabled.</div>';
    return;
}

// Include the component helper
$componentPath = JPATH_SITE . '/components/com_scorpionopeninghours/helpers/scorpionopeninghours.php';
if (!file_exists($componentPath)) {
    echo '<div class="alert alert-error">Scorpion Opening Hours Component helper not found.</div>';
    return;
}

require_once $componentPath;

// Get parameters
$openingHoursId = $params->get('opening_hours_id', null);
$templateOverride = $params->get('template_override', '');
$moreStyle = $params->get('more_style', '');
$showFutureHours = $params->get('show_future_additional_hours', 1);
$numberFutureHours = $params->get('number_future_additional_hours', 3);

// If no specific opening hours selected, get the default one
if (empty($openingHoursId)) {
    $openingHoursId = null; // This will make the helper load the default
}

// Create helper instance
try {
    $helper = new ScorpionopeninghoursHelper($openingHoursId, $module->id, $templateOverride ?: 'default', $moreStyle, $showFutureHours, $numberFutureHours);
} catch (Exception $e) {
    echo '<div class="alert alert-error">Error loading opening hours: ' . $e->getMessage() . '</div>';
    return;
}

// Set template based on override or layout parameter
$template = $templateOverride ?: $params->get('layout', 'default');

// Opening the chosen template/layout
require ModuleHelper::getLayoutPath('mod_scorpion_openinghours_next', $template);
