<?php
/**
 * @version     mod_scorpion_install.php - 25/04/2023
 * @author		Edwin Witlox
 * @copyright   Copyright (C) Scorpion Computers and Software, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; http://www.gnu.org/copyleft/gpl.html
 * @email       info@ScorpionComputers.nl
 */

// No direct access to this file
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\Manifest\PackageManifest as JPackageManifest;

class moduleSettings
{
    public $moduleNameTech = 'mod_scorpion_countdown';
    public $moduleNameFull = 'Scorpion Countdown';
}

class mod_scorpion_countdownInstallerScript
{
    static $name;
    static $package_name;
    static $current_version;
    static $previous_version;

    // This is the first function to run
    public function preflight($install_type, $adapter)
    {
        // Getting the main settings
        $settings = new moduleSettings;

        // Add an extra check
        if (!in_array($install_type, ['install', 'update'])) {
            return true;
        }

        $manifest = $adapter->getManifest();
        static::$package_name            = trim($settings->moduleNameTech);
        static::$name                    = trim($manifest->name);
        static::$current_version         = trim($manifest->version);
        if ($install_type == 'update') {
            static::$previous_version = self::getPreviousVersion();
        }

        return true;
    }

    // This is run with the first installation of the module
    public function install($parent)
    {

        self::showScorpionInfo();
        self::showSuccesMessage('install', '');
        self::getLatestChangelog(false);
    }

    // This is run with the update of the module
    function update($parent)
    {
        self::showScorpionInfo();
        self::getLatestChangelog(true);
        self::showSuccesMessage('update', $extraResultText);
    }

    // This runs after update/install
    public function postflight($install_type, $parent)
    {
        return true;
    }

    private static function getPreviousVersion($package_name = '')
    {
        $package_name  = $package_name ?: static::$package_name;
        $manifest_file = self::getMainXmlFile($package_name);

        return self::getVersionFromManifest($manifest_file);
    }

    private static function getMainXmlFile($package_name = '')
    {
        $package_name = $package_name ?: static::$package_name;

        $file_paths = [
            self::getManifestFilePathSystemPlugin($package_name),
            self::getManifestFilePathContentPlugin($package_name),
            self::getManifestFilePathModule($package_name),
        ];

        foreach ($file_paths as $file_path) {
            if (file_exists($file_path)) {
                return $file_path;
            }
        }

        return '';
    }

    private static function getVersionFromManifest($manifest_file)
    {
        if (!$manifest_file || !file_exists($manifest_file)) {
            return '';
        }

        $manifest = new JPackageManifest($manifest_file);

        return isset($manifest->version) ? trim($manifest->version) : '';
    }

    private static function getManifestFilePathModule($package_name = '')
    {
        $package_name = $package_name ?: static::$package_name;

        return JPATH_SITE . '/modules/' . $package_name . '/' . $package_name . '.xml';
    }

    private static function getManifestFilePathSystemPlugin($package_name = '')
    {
        $package_name = $package_name ?: static::$package_name;

        return JPATH_PLUGINS . '/system/' . $package_name . '/' . $package_name . '.xml';
    }

    private static function getManifestFilePathContentPlugin($package_name = '')
    {
        $package_name = $package_name ?: static::$package_name;

        return JPATH_PLUGINS . '/content/' . $package_name . '/' . $package_name . '.xml';
    }

    function showScorpionInfo()
    {
        $settings = new moduleSettings;
        $infoText = '<h2>' . $settings->moduleNameFull . '</h2>';
        echo $infoText;
    }

    function showSuccesMessage($installType, $extraResultText = '')
    {
        $settings = new moduleSettings;

        // For development
        // $extraResultText .= "<p>package_name: " . static::$package_name . "</p><br>";
        // $extraResultText .= "<p>name: " . static::$name . "</p><br>";
        // $extraResultText .= "<p>current_version: " . static::$current_version . "</p><br>";
        // $extraResultText .= "<p>previous_version: " . static::$previous_version . "</p><br>";
        // $extraResultText .= "<p>JPATH_SITE: " . JPATH_SITE . "</p><br>";
        // $extraResultText .= "<p>JPATH_PLUGINS: " . JPATH_PLUGINS . "</p><br>";

        $msgStyleBefore = '<p style="border-radius:4px;display:block;border:1px solid #BCE8F1;padding:10px 15px;background:#D8EDF7;color:#31718F;font-weight:400;">';
        $msgStyleAfter = '</p>';
        $linkToModuleManager = '<strong><a style="color:#333;text-decoration:underline;" href="index.php?option=com_modules&view=modules&filter_search=&filter_module=' . $settings->moduleNameTech . '">Open Module Manager</a></strong> to publish the module.';
        $msgInstall = $msgStyleBefore . '' . $settings->moduleNameFull . ' is installed succesfully. ' . $linkToModuleManager . $msgStyleAfter;
        $msgUpdate = $msgStyleBefore . '' . $settings->moduleNameFull . ' is updated succesfully. ' . $linkToModuleManager . $msgStyleAfter;
        $msgInstall .= $extraResultText;
        $msgUpdate .= $extraResultText;
        if ($installType == 'install') {
            echo $msgInstall;
        } else if ($installType == 'update') {
            echo $msgUpdate;
        }
    }

    function getLatestChangelog($onlyLatest)
    {
        $settings = new moduleSettings;
        // Reading the content of the changelog into a string
        $filenameWithPath = JPATH_ROOT . '/modules/' . $settings->moduleNameTech . '/changelog.txt';
        $allChanges = file_get_contents($filenameWithPath);
        $onlyLastestChanges = explode('-----', $allChanges);

        $output = $onlyLatest ? '<h4>New in this version</h4>' : '<h4>Changelog</h4>';
        $output .= '<pre>';
        $output .= $onlyLatest ? $onlyLastestChanges[0] : $allChanges;
        $output .= '</pre>';
        echo $output;
    }
}
